/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper;

import com.graphhopper.Trip;
import com.graphhopper.util.InstructionList;
import com.graphhopper.util.PointList;
import com.graphhopper.util.details.PathDetail;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.locationtech.jts.geom.Envelope;

public class ResponsePath {
    private final List<Throwable> errors = new ArrayList<Throwable>(4);
    private List<String> description;
    private double distance;
    private double ascend;
    private double descend;
    private double routeWeight;
    private long time;
    private String debugInfo = "";
    private InstructionList instructions;
    private PointList waypointList = PointList.EMPTY;
    private PointList pointList = PointList.EMPTY;
    private int numChanges;
    private final List<Trip.Leg> legs = new ArrayList<Trip.Leg>(5);
    private final List<Integer> pointsOrder = new ArrayList<Integer>(5);
    private final Map<String, List<PathDetail>> pathDetails = new HashMap<String, List<PathDetail>>();
    private BigDecimal fare;
    private boolean impossible = false;

    public List<String> getDescription() {
        if (this.description == null) {
            return Collections.emptyList();
        }
        return this.description;
    }

    public ResponsePath setDescription(List<String> names) {
        this.description = names;
        return this;
    }

    public ResponsePath addDebugInfo(String debugInfo) {
        if (debugInfo == null) {
            throw new IllegalStateException("Debug information has to be none null");
        }
        if (!this.debugInfo.isEmpty()) {
            this.debugInfo = this.debugInfo + ";";
        }
        this.debugInfo = this.debugInfo + debugInfo;
        return this;
    }

    public String getDebugInfo() {
        return this.debugInfo;
    }

    public ResponsePath setPointsOrder(List<Integer> list) {
        this.pointsOrder.clear();
        this.pointsOrder.addAll(list);
        return this;
    }

    public List<Integer> getPointsOrder() {
        return this.pointsOrder;
    }

    public PointList getPoints() {
        this.check("getPoints");
        return this.pointList;
    }

    public ResponsePath setPoints(PointList points) {
        if (this.pointList != PointList.EMPTY) {
            throw new IllegalStateException("Cannot call setPoint twice");
        }
        this.pointList = points;
        return this;
    }

    public PointList getWaypoints() {
        this.check("getWaypoints");
        return this.waypointList;
    }

    public void setWaypoints(PointList wpList) {
        if (this.waypointList != PointList.EMPTY) {
            throw new IllegalStateException("Cannot call setWaypoints twice");
        }
        this.waypointList = wpList;
    }

    public double getDistance() {
        this.check("getDistance");
        return this.distance;
    }

    public ResponsePath setDistance(double distance) {
        this.distance = distance;
        return this;
    }

    public double getAscend() {
        return this.ascend;
    }

    public ResponsePath setAscend(double ascend) {
        if (ascend < 0.0 || Double.isNaN(ascend)) {
            throw new IllegalStateException("ascend has to be positive but was " + ascend);
        }
        this.ascend = ascend;
        return this;
    }

    public double getDescend() {
        return this.descend;
    }

    public ResponsePath setDescend(double descend) {
        if (descend < 0.0 || Double.isNaN(descend)) {
            throw new IllegalStateException("descend has to be positive but was " + descend);
        }
        this.descend = descend;
        return this;
    }

    public long getTime() {
        this.check("getTimes");
        return this.time;
    }

    public ResponsePath setTime(long timeInMillis) {
        this.time = timeInMillis;
        return this;
    }

    public double getRouteWeight() {
        this.check("getRouteWeight");
        return this.routeWeight;
    }

    public ResponsePath setRouteWeight(double weight) {
        this.routeWeight = weight;
        return this;
    }

    public Envelope calcBBox2D() {
        this.check("calcRouteBBox");
        Envelope bounds = new Envelope();
        for (int i = 0; i < this.pointList.getSize(); ++i) {
            bounds.expandToInclude(this.pointList.getLon(i), this.pointList.getLat(i));
        }
        return bounds;
    }

    public String toString() {
        String str = "nodes:" + this.pointList.getSize() + "; " + this.pointList.toString();
        if (this.instructions != null && !this.instructions.isEmpty()) {
            str = str + ", " + this.instructions.toString();
        }
        if (this.hasErrors()) {
            str = str + ", " + this.errors.toString();
        }
        return str;
    }

    public InstructionList getInstructions() {
        this.check("getInstructions");
        if (this.instructions == null) {
            throw new IllegalArgumentException("To access instructions you need to enable creation before routing");
        }
        return this.instructions;
    }

    public void setInstructions(InstructionList instructions) {
        this.instructions = instructions;
    }

    public void addPathDetails(Map<String, List<PathDetail>> details) {
        if (!this.pathDetails.isEmpty() && !details.isEmpty() && this.pathDetails.size() != details.size()) {
            throw new IllegalStateException("Details have to be the same size");
        }
        for (Map.Entry<String, List<PathDetail>> detailEntry : details.entrySet()) {
            if (this.pathDetails.containsKey(detailEntry.getKey())) {
                List<PathDetail> pd = this.pathDetails.get(detailEntry.getKey());
                ResponsePath.merge(pd, detailEntry.getValue());
                continue;
            }
            this.pathDetails.put(detailEntry.getKey(), detailEntry.getValue());
        }
    }

    public static void merge(List<PathDetail> pathDetails, List<PathDetail> otherDetails) {
        if (!pathDetails.isEmpty() && !otherDetails.isEmpty()) {
            boolean extend;
            PathDetail lastDetail = pathDetails.get(pathDetails.size() - 1);
            boolean bl = lastDetail.getValue() != null ? lastDetail.getValue().equals(otherDetails.get(0).getValue()) : (extend = otherDetails.get(0).getValue() != null);
            if (extend) {
                lastDetail.setLast(otherDetails.get(0).getLast());
                otherDetails.remove(0);
            }
        }
        pathDetails.addAll(otherDetails);
    }

    public Map<String, List<PathDetail>> getPathDetails() {
        return this.pathDetails;
    }

    private void check(String method) {
        if (this.hasErrors()) {
            throw new RuntimeException("You cannot call " + method + " if response contains errors. Check this with ghResponse.hasErrors(). Errors are: " + this.getErrors());
        }
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public List<Throwable> getErrors() {
        return this.errors;
    }

    public ResponsePath addError(Throwable error) {
        this.errors.add(error);
        return this;
    }

    public ResponsePath addErrors(List<Throwable> errors) {
        this.errors.addAll(errors);
        return this;
    }

    public void setNumChanges(int numChanges) {
        this.numChanges = numChanges;
    }

    public int getNumChanges() {
        return this.numChanges;
    }

    public List<Trip.Leg> getLegs() {
        return this.legs;
    }

    public void setFare(BigDecimal fare) {
        this.fare = fare;
    }

    public BigDecimal getFare() {
        return this.fare;
    }

    public boolean isImpossible() {
        return this.impossible;
    }

    public void setImpossible(boolean impossible) {
        this.impossible = impossible;
    }
}

