/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.httpclient;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.httpclient.HttpClientMetricNameStrategy;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpRequest;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;

public class HttpClientMetricNameStrategies {
    public static final HttpClientMetricNameStrategy METHOD_ONLY = (name, request) -> MetricRegistry.name(HttpClient.class, name, HttpClientMetricNameStrategies.methodNameString(request));
    public static final HttpClientMetricNameStrategy HOST_AND_METHOD = (name, request) -> MetricRegistry.name(HttpClient.class, name, HttpClientMetricNameStrategies.requestURI(request).getHost(), HttpClientMetricNameStrategies.methodNameString(request));
    public static final HttpClientMetricNameStrategy PATH_AND_METHOD = (name, request) -> {
        URIBuilder url = new URIBuilder(HttpClientMetricNameStrategies.requestURI(request));
        return MetricRegistry.name(HttpClient.class, name, url.getPath(), HttpClientMetricNameStrategies.methodNameString(request));
    };
    public static final HttpClientMetricNameStrategy QUERYLESS_URL_AND_METHOD = (name, request) -> {
        try {
            URIBuilder url = new URIBuilder(HttpClientMetricNameStrategies.requestURI(request));
            return MetricRegistry.name(HttpClient.class, name, url.removeQuery().build().toString(), HttpClientMetricNameStrategies.methodNameString(request));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    };

    private static String methodNameString(HttpRequest request) {
        return request.getRequestLine().getMethod().toLowerCase() + "-requests";
    }

    private static URI requestURI(HttpRequest request) {
        if (request instanceof HttpRequestWrapper) {
            return HttpClientMetricNameStrategies.requestURI(((HttpRequestWrapper)request).getOriginal());
        }
        return request instanceof HttpUriRequest ? ((HttpUriRequest)request).getURI() : URI.create(request.getRequestLine().getUri());
    }
}

