/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util.shapes;

import com.graphhopper.util.DistanceCalc;
import com.graphhopper.util.DistanceCalcEarth;
import com.graphhopper.util.NumHelper;
import com.graphhopper.util.PointList;
import com.graphhopper.util.shapes.BBox;
import com.graphhopper.util.shapes.Shape;

public class Circle
implements Shape {
    public final double radiusInMeter;
    private final double lat;
    private final double lon;
    private final double normedDist;
    private final BBox bbox;
    private DistanceCalc calc;

    public Circle(double lat, double lon, double radiusInMeter) {
        this(lat, lon, radiusInMeter, DistanceCalcEarth.DIST_EARTH);
    }

    public Circle(double lat, double lon, double radiusInMeter, DistanceCalc calc) {
        this.calc = calc;
        this.lat = lat;
        this.lon = lon;
        this.radiusInMeter = radiusInMeter;
        this.normedDist = calc.calcNormalizedDist(radiusInMeter);
        this.bbox = calc.createBBox(lat, lon, radiusInMeter);
    }

    public double getLat() {
        return this.lat;
    }

    public double getLon() {
        return this.lon;
    }

    @Override
    public boolean contains(double lat1, double lon1) {
        return this.normDist(lat1, lon1) <= this.normedDist;
    }

    @Override
    public BBox getBounds() {
        return this.bbox;
    }

    private double normDist(double lat1, double lon1) {
        return this.calc.calcNormalizedDist(this.lat, this.lon, lat1, lon1);
    }

    @Override
    public boolean intersects(PointList pointList) {
        int len = pointList.getSize();
        if (len == 0) {
            throw new IllegalArgumentException("PointList must not be empty");
        }
        double tmpLat = pointList.getLatitude(0);
        double tmpLon = pointList.getLongitude(0);
        if (len == 1) {
            return this.calc.calcNormalizedDist(this.lat, this.lon, tmpLat, tmpLon) <= this.normedDist;
        }
        for (int pointIndex = 1; pointIndex < len; ++pointIndex) {
            double wayLon;
            double wayLat = pointList.getLatitude(pointIndex);
            if (this.calc.validEdgeDistance(this.lat, this.lon, tmpLat, tmpLon, wayLat, wayLon = pointList.getLongitude(pointIndex)) ? this.calc.calcNormalizedEdgeDistance(this.lat, this.lon, tmpLat, tmpLon, wayLat, wayLon) <= this.normedDist : this.calc.calcNormalizedDist(this.lat, this.lon, tmpLat, tmpLon) <= this.normedDist || pointIndex + 1 == len && this.calc.calcNormalizedDist(this.lat, this.lon, wayLat, wayLon) <= this.normedDist) {
                return true;
            }
            tmpLat = wayLat;
            tmpLon = wayLon;
        }
        return false;
    }

    public boolean intersects(BBox b) {
        if (this.lat > b.maxLat) {
            if (this.lon < b.minLon) {
                return this.normDist(b.maxLat, b.minLon) <= this.normedDist;
            }
            if (this.lon > b.maxLon) {
                return this.normDist(b.maxLat, b.maxLon) <= this.normedDist;
            }
            return b.maxLat - this.bbox.minLat > 0.0;
        }
        if (this.lat < b.minLat) {
            if (this.lon < b.minLon) {
                return this.normDist(b.minLat, b.minLon) <= this.normedDist;
            }
            if (this.lon > b.maxLon) {
                return this.normDist(b.minLat, b.maxLon) <= this.normedDist;
            }
            return this.bbox.maxLat - b.minLat > 0.0;
        }
        if (this.lon < b.minLon) {
            return this.bbox.maxLon - b.minLon > 0.0;
        }
        if (this.lon > b.maxLon) {
            return b.maxLon - this.bbox.minLon > 0.0;
        }
        return true;
    }

    public boolean contains(BBox b) {
        if (this.bbox.contains(b)) {
            return this.contains(b.maxLat, b.minLon) && this.contains(b.minLat, b.minLon) && this.contains(b.maxLat, b.maxLon) && this.contains(b.minLat, b.maxLon);
        }
        return false;
    }

    public boolean contains(Circle c) {
        double res = this.radiusInMeter - c.radiusInMeter;
        if (res < 0.0) {
            return false;
        }
        return this.calc.calcDist(this.lat, this.lon, c.lat, c.lon) <= res;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        Circle b = (Circle)obj;
        return NumHelper.equalsEps(this.lat, b.lat) && NumHelper.equalsEps(this.lon, b.lon) && NumHelper.equalsEps(this.radiusInMeter, b.radiusInMeter);
    }

    public int hashCode() {
        int hash = 3;
        hash = 17 * hash + (int)(Double.doubleToLongBits(this.lat) ^ Double.doubleToLongBits(this.lat) >>> 32);
        hash = 17 * hash + (int)(Double.doubleToLongBits(this.lon) ^ Double.doubleToLongBits(this.lon) >>> 32);
        hash = 17 * hash + (int)(Double.doubleToLongBits(this.radiusInMeter) ^ Double.doubleToLongBits(this.radiusInMeter) >>> 32);
        return hash;
    }

    public String toString() {
        return this.lat + "," + this.lon + ", radius:" + this.radiusInMeter;
    }
}

