/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.graphhopper.util.DistanceCalc;
import com.graphhopper.util.DistanceCalcEarth;
import com.graphhopper.util.Instruction;
import com.graphhopper.util.InstructionList;
import com.graphhopper.util.PointList;

public class Instructions {
    public static Instruction find(InstructionList instructions, double lat, double lon, double maxDistance) {
        if (instructions.size() == 0) {
            return null;
        }
        PointList points = instructions.get(0).getPoints();
        double prevLat = points.getLatitude(0);
        double prevLon = points.getLongitude(0);
        DistanceCalc distCalc = DistanceCalcEarth.DIST_EARTH;
        double foundMinDistance = distCalc.calcNormalizedDist(lat, lon, prevLat, prevLon);
        int foundInstruction = 0;
        if (instructions.size() > 1) {
            for (int instructionIndex = 0; instructionIndex < instructions.size(); ++instructionIndex) {
                points = instructions.get(instructionIndex).getPoints();
                for (int pointIndex = 0; pointIndex < points.size(); ++pointIndex) {
                    double currLat = points.getLatitude(pointIndex);
                    double currLon = points.getLongitude(pointIndex);
                    if (instructionIndex != 0 || pointIndex != 0) {
                        double distance;
                        int index = instructionIndex;
                        if (distCalc.validEdgeDistance(lat, lon, currLat, currLon, prevLat, prevLon)) {
                            distance = distCalc.calcNormalizedEdgeDistance(lat, lon, currLat, currLon, prevLat, prevLon);
                            if (pointIndex > 0) {
                                ++index;
                            }
                        } else {
                            distance = distCalc.calcNormalizedDist(lat, lon, currLat, currLon);
                            if (pointIndex > 0) {
                                ++index;
                            }
                        }
                        if (distance < foundMinDistance) {
                            foundMinDistance = distance;
                            foundInstruction = index;
                        }
                    }
                    prevLat = currLat;
                    prevLon = currLon;
                }
            }
        }
        if (distCalc.calcDenormalizedDist(foundMinDistance) > maxDistance) {
            return null;
        }
        if (foundInstruction == instructions.size()) {
            --foundInstruction;
        }
        return instructions.get(foundInstruction);
    }
}

