/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.graphhopper.util.DistanceCalcEarth;

public class DistancePlaneProjection
extends DistanceCalcEarth {
    public static final DistancePlaneProjection DIST_PLANE = new DistancePlaneProjection();

    @Override
    public double calcDist(double fromLat, double fromLon, double toLat, double toLon) {
        double normedDist = this.calcNormalizedDist(fromLat, fromLon, toLat, toLon);
        return 6371000.0 * Math.sqrt(normedDist);
    }

    @Override
    public double calcDist3D(double fromLat, double fromLon, double fromHeight, double toLat, double toLon, double toHeight) {
        double dEleNorm = this.hasElevationDiff(fromHeight, toHeight) ? this.calcNormalizedDist(toHeight - fromHeight) : 0.0;
        double normedDist = this.calcNormalizedDist(fromLat, fromLon, toLat, toLon);
        return 6371000.0 * Math.sqrt(normedDist + dEleNorm);
    }

    @Override
    public double calcDenormalizedDist(double normedDist) {
        return 6371000.0 * Math.sqrt(normedDist);
    }

    @Override
    public double calcNormalizedDist(double dist) {
        double tmp = dist / 6371000.0;
        return tmp * tmp;
    }

    @Override
    public double calcNormalizedDist(double fromLat, double fromLon, double toLat, double toLon) {
        double dLat = Math.toRadians(toLat - fromLat);
        double dLon = Math.toRadians(toLon - fromLon);
        double left = Math.cos(Math.toRadians((fromLat + toLat) / 2.0)) * dLon;
        return dLat * dLat + left * left;
    }

    @Override
    public String toString() {
        return "PLANE_PROJ";
    }
}

