/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.graphhopper.util.DistanceCalc;
import com.graphhopper.util.PointList;
import com.graphhopper.util.shapes.BBox;
import com.graphhopper.util.shapes.GHPoint;

public class DistanceCalcEarth
implements DistanceCalc {
    public static final double R = 6371000.0;
    public static final double R_EQ = 6378137.0;
    public static final double C = 4.003017359204114E7;
    public static final double KM_MILE = 1.609344;
    public static final double METERS_PER_DEGREE = 111194.92664455873;
    public static final DistanceCalc DIST_EARTH = new DistanceCalcEarth();

    @Override
    public double calcDist(double fromLat, double fromLon, double toLat, double toLon) {
        double normedDist = this.calcNormalizedDist(fromLat, fromLon, toLat, toLon);
        return 1.2742E7 * Math.asin(Math.sqrt(normedDist));
    }

    @Override
    public double calcDist3D(double fromLat, double fromLon, double fromHeight, double toLat, double toLon, double toHeight) {
        double eleDelta = this.hasElevationDiff(fromHeight, toHeight) ? toHeight - fromHeight : 0.0;
        double len = this.calcDist(fromLat, fromLon, toLat, toLon);
        return Math.sqrt(eleDelta * eleDelta + len * len);
    }

    @Override
    public double calcDenormalizedDist(double normedDist) {
        return 1.2742E7 * Math.asin(Math.sqrt(normedDist));
    }

    @Override
    public double calcNormalizedDist(double dist) {
        double tmp = Math.sin(dist / 2.0 / 6371000.0);
        return tmp * tmp;
    }

    @Override
    public double calcNormalizedDist(double fromLat, double fromLon, double toLat, double toLon) {
        double sinDeltaLat = Math.sin(Math.toRadians(toLat - fromLat) / 2.0);
        double sinDeltaLon = Math.sin(Math.toRadians(toLon - fromLon) / 2.0);
        return sinDeltaLat * sinDeltaLat + sinDeltaLon * sinDeltaLon * Math.cos(Math.toRadians(fromLat)) * Math.cos(Math.toRadians(toLat));
    }

    @Override
    public double calcCircumference(double lat) {
        return 4.003017359204114E7 * Math.cos(Math.toRadians(lat));
    }

    public boolean isDateLineCrossOver(double lon1, double lon2) {
        return Math.abs(lon1 - lon2) > 180.0;
    }

    @Override
    public BBox createBBox(double lat, double lon, double radiusInMeter) {
        if (radiusInMeter <= 0.0) {
            throw new IllegalArgumentException("Distance must not be zero or negative! " + radiusInMeter + " lat,lon:" + lat + "," + lon);
        }
        double dLon = 360.0 / (this.calcCircumference(lat) / radiusInMeter);
        double dLat = 360.0 / (4.003017359204114E7 / radiusInMeter);
        return new BBox(lon - dLon, lon + dLon, lat - dLat, lat + dLat);
    }

    @Override
    public double calcNormalizedEdgeDistance(double r_lat_deg, double r_lon_deg, double a_lat_deg, double a_lon_deg, double b_lat_deg, double b_lon_deg) {
        double shrinkFactor = this.calcShrinkFactor(a_lat_deg, b_lat_deg);
        double a_lat = a_lat_deg;
        double a_lon = a_lon_deg * shrinkFactor;
        double b_lat = b_lat_deg;
        double b_lon = b_lon_deg * shrinkFactor;
        double r_lat = r_lat_deg;
        double r_lon = r_lon_deg * shrinkFactor;
        double delta_lon = b_lon - a_lon;
        double delta_lat = b_lat - a_lat;
        if (delta_lat == 0.0) {
            return this.calcNormalizedDist(a_lat_deg, r_lon_deg, r_lat_deg, r_lon_deg);
        }
        if (delta_lon == 0.0) {
            return this.calcNormalizedDist(r_lat_deg, a_lon_deg, r_lat_deg, r_lon_deg);
        }
        double norm = delta_lon * delta_lon + delta_lat * delta_lat;
        double factor = ((r_lon - a_lon) * delta_lon + (r_lat - a_lat) * delta_lat) / norm;
        double c_lon = a_lon + factor * delta_lon;
        double c_lat = a_lat + factor * delta_lat;
        return this.calcNormalizedDist(c_lat, c_lon / shrinkFactor, r_lat_deg, r_lon_deg);
    }

    @Override
    public double calcNormalizedEdgeDistance3D(double r_lat_deg, double r_lon_deg, double r_ele_m, double a_lat_deg, double a_lon_deg, double a_ele_m, double b_lat_deg, double b_lon_deg, double b_ele_m) {
        double norm;
        double b_ele;
        double delta_ele;
        double a_ele;
        double r_ele;
        double b_lat;
        double delta_lat;
        double a_lat;
        double r_lat;
        double b_lon;
        double delta_lon;
        double a_lon;
        if (Double.isNaN(r_ele_m) || Double.isNaN(a_ele_m) || Double.isNaN(b_ele_m)) {
            return this.calcNormalizedEdgeDistance(r_lat_deg, r_lon_deg, a_lat_deg, a_lon_deg, b_lat_deg, b_lon_deg);
        }
        double shrinkFactor = this.calcShrinkFactor(a_lat_deg, b_lat_deg);
        double r_lon = r_lon_deg * shrinkFactor;
        double factor = ((r_lon - (a_lon = a_lon_deg * shrinkFactor)) * (delta_lon = (b_lon = b_lon_deg * shrinkFactor) - a_lon) + ((r_lat = r_lat_deg) - (a_lat = a_lat_deg)) * (delta_lat = (b_lat = b_lat_deg) - a_lat) + ((r_ele = r_ele_m / 111194.92664455873) - (a_ele = a_ele_m / 111194.92664455873)) * (delta_ele = (b_ele = b_ele_m / 111194.92664455873) - a_ele)) / (norm = delta_lon * delta_lon + delta_lat * delta_lat + delta_ele * delta_ele);
        if (Double.isNaN(factor)) {
            factor = 0.0;
        }
        double c_lon = a_lon + factor * delta_lon;
        double c_lat = a_lat + factor * delta_lat;
        double c_ele_m = (a_ele + factor * delta_ele) * 111194.92664455873;
        return this.calcNormalizedDist(c_lat, c_lon / shrinkFactor, r_lat_deg, r_lon_deg) + this.calcNormalizedDist(r_ele_m - c_ele_m);
    }

    double calcShrinkFactor(double a_lat_deg, double b_lat_deg) {
        return Math.cos(Math.toRadians((a_lat_deg + b_lat_deg) / 2.0));
    }

    @Override
    public GHPoint calcCrossingPointToEdge(double r_lat_deg, double r_lon_deg, double a_lat_deg, double a_lon_deg, double b_lat_deg, double b_lon_deg) {
        double shrinkFactor = this.calcShrinkFactor(a_lat_deg, b_lat_deg);
        double a_lat = a_lat_deg;
        double a_lon = a_lon_deg * shrinkFactor;
        double b_lat = b_lat_deg;
        double b_lon = b_lon_deg * shrinkFactor;
        double r_lat = r_lat_deg;
        double r_lon = r_lon_deg * shrinkFactor;
        double delta_lon = b_lon - a_lon;
        double delta_lat = b_lat - a_lat;
        if (delta_lat == 0.0) {
            return new GHPoint(a_lat_deg, r_lon_deg);
        }
        if (delta_lon == 0.0) {
            return new GHPoint(r_lat_deg, a_lon_deg);
        }
        double norm = delta_lon * delta_lon + delta_lat * delta_lat;
        double factor = ((r_lon - a_lon) * delta_lon + (r_lat - a_lat) * delta_lat) / norm;
        double c_lon = a_lon + factor * delta_lon;
        double c_lat = a_lat + factor * delta_lat;
        return new GHPoint(c_lat, c_lon / shrinkFactor);
    }

    @Override
    public boolean validEdgeDistance(double r_lat_deg, double r_lon_deg, double a_lat_deg, double a_lon_deg, double b_lat_deg, double b_lon_deg) {
        double shrinkFactor = this.calcShrinkFactor(a_lat_deg, b_lat_deg);
        double a_lat = a_lat_deg;
        double a_lon = a_lon_deg * shrinkFactor;
        double b_lat = b_lat_deg;
        double b_lon = b_lon_deg * shrinkFactor;
        double r_lat = r_lat_deg;
        double r_lon = r_lon_deg * shrinkFactor;
        double ar_x = r_lon - a_lon;
        double ar_y = r_lat - a_lat;
        double ab_x = b_lon - a_lon;
        double ab_y = b_lat - a_lat;
        double ab_ar = ar_x * ab_x + ar_y * ab_y;
        double rb_x = b_lon - r_lon;
        double rb_y = b_lat - r_lat;
        double ab_rb = rb_x * ab_x + rb_y * ab_y;
        return ab_ar > 0.0 && ab_rb > 0.0;
    }

    @Override
    public GHPoint projectCoordinate(double latInDeg, double lonInDeg, double distanceInMeter, double headingClockwiseFromNorth) {
        double angularDistance = distanceInMeter / 6371000.0;
        double latInRadians = Math.toRadians(latInDeg);
        double lonInRadians = Math.toRadians(lonInDeg);
        double headingInRadians = Math.toRadians(headingClockwiseFromNorth);
        double projectedLat = Math.asin(Math.sin(latInRadians) * Math.cos(angularDistance) + Math.cos(latInRadians) * Math.sin(angularDistance) * Math.cos(headingInRadians));
        double projectedLon = lonInRadians + Math.atan2(Math.sin(headingInRadians) * Math.sin(angularDistance) * Math.cos(latInRadians), Math.cos(angularDistance) - Math.sin(latInRadians) * Math.sin(projectedLat));
        projectedLon = (projectedLon + Math.PI * 3) % (Math.PI * 2) - Math.PI;
        projectedLat = Math.toDegrees(projectedLat);
        projectedLon = Math.toDegrees(projectedLon);
        return new GHPoint(projectedLat, projectedLon);
    }

    @Override
    public GHPoint intermediatePoint(double f, double lat1, double lon1, double lat2, double lon2) {
        double lat1radians = Math.toRadians(lat1);
        double lon1radians = Math.toRadians(lon1);
        double lat2radians = Math.toRadians(lat2);
        double lon2radians = Math.toRadians(lon2);
        double deltaLat = lat2radians - lat1radians;
        double deltaLon = lon2radians - lon1radians;
        double cosLat1 = Math.cos(lat1radians);
        double cosLat2 = Math.cos(lat2radians);
        double sinHalfDeltaLat = Math.sin(deltaLat / 2.0);
        double sinHalfDeltaLon = Math.sin(deltaLon / 2.0);
        double a = sinHalfDeltaLat * sinHalfDeltaLat + cosLat1 * cosLat2 * sinHalfDeltaLon * sinHalfDeltaLon;
        double angularDistance = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        double sinDistance = Math.sin(angularDistance);
        if (angularDistance == 0.0) {
            return new GHPoint(lat1, lon1);
        }
        double A2 = Math.sin((1.0 - f) * angularDistance) / sinDistance;
        double B = Math.sin(f * angularDistance) / sinDistance;
        double x = A2 * cosLat1 * Math.cos(lon1radians) + B * cosLat2 * Math.cos(lon2radians);
        double y = A2 * cosLat1 * Math.sin(lon1radians) + B * cosLat2 * Math.sin(lon2radians);
        double z = A2 * Math.sin(lat1radians) + B * Math.sin(lat2radians);
        double midLat = Math.toDegrees(Math.atan2(z, Math.sqrt(x * x + y * y)));
        double midLon = Math.toDegrees(Math.atan2(y, x));
        return new GHPoint(midLat, midLon);
    }

    @Override
    public final double calcDistance(PointList pointList) {
        double prevLat = Double.NaN;
        double prevLon = Double.NaN;
        double prevEle = Double.NaN;
        double dist = 0.0;
        for (int i = 0; i < pointList.size(); ++i) {
            if (i > 0) {
                dist = pointList.is3D() ? (dist += this.calcDist3D(prevLat, prevLon, prevEle, pointList.getLat(i), pointList.getLon(i), pointList.getEle(i))) : (dist += this.calcDist(prevLat, prevLon, pointList.getLat(i), pointList.getLon(i)));
            }
            prevLat = pointList.getLat(i);
            prevLon = pointList.getLon(i);
            if (!pointList.is3D()) continue;
            prevEle = pointList.getEle(i);
        }
        return dist;
    }

    @Override
    public boolean isCrossBoundary(double lon1, double lon2) {
        return Math.abs(lon1 - lon2) > 300.0;
    }

    protected boolean hasElevationDiff(double a, double b) {
        return a != b && !Double.isNaN(a) && !Double.isNaN(b);
    }

    public String toString() {
        return "EXACT";
    }
}

