/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.weighting.AbstractWeighting;
import com.graphhopper.routing.weighting.DefaultTurnCostProvider;
import com.graphhopper.routing.weighting.FastestWeighting;
import com.graphhopper.routing.weighting.ShortFastestWeighting;
import com.graphhopper.routing.weighting.ShortestWeighting;
import com.graphhopper.routing.weighting.TurnCostProvider;
import com.graphhopper.storage.CHConfig;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.storage.MMapDirectory;
import com.graphhopper.storage.RAMDirectory;
import com.graphhopper.storage.TurnCostStorage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GraphBuilder {
    private final EncodingManager encodingManager;
    private Directory dir = new RAMDirectory();
    private boolean elevation;
    private boolean turnCosts;
    private long bytes = 100L;
    private int segmentSize = -1;
    private List<String> chConfigStrings = new ArrayList<String>();
    private List<CHConfig> chConfigs = new ArrayList<CHConfig>();

    public static GraphBuilder start(EncodingManager encodingManager) {
        return new GraphBuilder(encodingManager);
    }

    public GraphBuilder(EncodingManager encodingManager) {
        this.encodingManager = encodingManager;
        this.turnCosts = encodingManager.needsTurnCostsSupport();
    }

    public GraphBuilder setCHConfigStrings(String ... profileStrings) {
        this.chConfigStrings = Arrays.asList(profileStrings);
        return this;
    }

    public GraphBuilder setCHConfigs(List<CHConfig> chConfigs) {
        this.chConfigs = chConfigs;
        return this;
    }

    public GraphBuilder setCHConfigs(CHConfig ... chConfigs) {
        return this.setCHConfigs(new ArrayList<CHConfig>(Arrays.asList(chConfigs)));
    }

    public GraphBuilder setDir(Directory dir) {
        this.dir = dir;
        return this;
    }

    public GraphBuilder setMMap(String location) {
        return this.setDir(new MMapDirectory(location));
    }

    public GraphBuilder setRAM() {
        return this.setDir(new RAMDirectory());
    }

    public GraphBuilder setRAM(String location) {
        return this.setDir(new RAMDirectory(location));
    }

    public GraphBuilder setRAM(String location, boolean store) {
        return this.setDir(new RAMDirectory(location, store));
    }

    public GraphBuilder setBytes(long bytes) {
        this.bytes = bytes;
        return this;
    }

    public GraphBuilder set3D(boolean withElevation) {
        this.elevation = withElevation;
        return this;
    }

    public GraphBuilder withTurnCosts(boolean turnCosts) {
        this.turnCosts = turnCosts;
        return this;
    }

    public GraphBuilder setSegmentSize(int segmentSize) {
        this.segmentSize = segmentSize;
        return this;
    }

    public GraphHopperStorage build() {
        GraphHopperStorage ghStorage = new GraphHopperStorage(this.dir, this.encodingManager, this.elevation, this.turnCosts, this.segmentSize);
        this.addCHProfilesFromStrings(ghStorage.getTurnCostStorage());
        ghStorage.addCHGraphs(this.chConfigs);
        return ghStorage;
    }

    public GraphHopperStorage create() {
        return this.build().create(this.bytes);
    }

    private void addCHProfilesFromStrings(TurnCostStorage turnCostStorage) {
        for (String profileString : this.chConfigStrings) {
            AbstractWeighting weighting;
            TurnCostProvider turnCostProvider;
            String[] split = profileString.split("\\|");
            if (split.length < 4) {
                throw new IllegalArgumentException("Invalid CH profile string: " + profileString + ". Expected something like: 'my_profile|car|fastest|node' or 'your_profile|bike|shortest|edge|40'");
            }
            String profileName = split[0];
            FlagEncoder encoder = this.encodingManager.getEncoder(split[1]);
            String weightingStr = split[2];
            String edgeOrNode = split[3];
            int uTurnCostsInt = -1;
            if (split.length == 5) {
                uTurnCostsInt = Integer.parseInt(split[4]);
            }
            boolean edgeBased = false;
            if (edgeOrNode.equals("edge")) {
                if (turnCostStorage == null) {
                    throw new IllegalArgumentException("For edge-based CH profiles you need a turn cost storage");
                }
                turnCostProvider = new DefaultTurnCostProvider(encoder, turnCostStorage, uTurnCostsInt);
                edgeBased = true;
            } else if (edgeOrNode.equals("node")) {
                turnCostProvider = TurnCostProvider.NO_TURN_COST_PROVIDER;
            } else {
                throw new IllegalArgumentException("Invalid CH profile string: " + profileString);
            }
            if (weightingStr.equalsIgnoreCase("fastest")) {
                weighting = new FastestWeighting(encoder, turnCostProvider);
            } else if (weightingStr.equalsIgnoreCase("shortest")) {
                weighting = new ShortestWeighting(encoder, turnCostProvider);
            } else if (weightingStr.equalsIgnoreCase("short_fastest")) {
                weighting = new ShortFastestWeighting(encoder, 0.1, turnCostProvider);
            } else {
                throw new IllegalArgumentException("Weighting not supported using this method, maybe you can use setCHProfile instead: " + weightingStr);
            }
            this.chConfigs.add(new CHConfig(profileName, weighting, edgeBased));
        }
    }
}

