/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.RouteNetwork;
import com.graphhopper.routing.util.FootFlagEncoder;
import com.graphhopper.routing.util.PriorityCode;
import com.graphhopper.routing.weighting.PriorityWeighting;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.FetchMode;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;
import com.graphhopper.util.PointList;
import java.util.Collection;
import java.util.TreeMap;

public class HikeFlagEncoder
extends FootFlagEncoder {
    public HikeFlagEncoder() {
        this(4, 1.0);
    }

    public HikeFlagEncoder(PMap properties) {
        this(properties.getInt("speed_bits", 4), properties.getDouble("speed_factor", 1.0));
        this.blockPrivate(properties.getBool("block_private", true));
        this.blockFords(properties.getBool("block_fords", false));
        this.blockBarriersByDefault(properties.getBool("block_barriers", false));
        this.speedTwoDirections = properties.getBool("speed_two_directions", false);
    }

    protected HikeFlagEncoder(int speedBits, double speedFactor) {
        super(speedBits, speedFactor);
        this.routeMap.put(RouteNetwork.INTERNATIONAL, PriorityCode.BEST.getValue());
        this.routeMap.put(RouteNetwork.NATIONAL, PriorityCode.BEST.getValue());
        this.routeMap.put(RouteNetwork.REGIONAL, PriorityCode.VERY_NICE.getValue());
        this.routeMap.put(RouteNetwork.LOCAL, PriorityCode.VERY_NICE.getValue());
        this.allowedSacScale.add("alpine_hiking");
        this.allowedSacScale.add("demanding_alpine_hiking");
        this.allowedSacScale.add("difficult_alpine_hiking");
    }

    @Override
    public int getVersion() {
        return 3;
    }

    @Override
    void collect(ReaderWay way, TreeMap<Double, Integer> weightToPrioMap) {
        String highway = way.getTag("highway");
        if (way.hasTag("foot", (Object)"designated")) {
            weightToPrioMap.put(100.0, PriorityCode.PREFER.getValue());
        }
        double maxSpeed = this.getMaxSpeed(way);
        if (this.safeHighwayTags.contains(highway) || this.isValidSpeed(maxSpeed) && maxSpeed <= 20.0) {
            weightToPrioMap.put(40.0, PriorityCode.PREFER.getValue());
            if (way.hasTag("tunnel", (Collection<String>)this.intendedValues)) {
                if (way.hasTag("sidewalk", (Collection<String>)this.sidewalksNoValues)) {
                    weightToPrioMap.put(40.0, PriorityCode.REACH_DEST.getValue());
                } else {
                    weightToPrioMap.put(40.0, PriorityCode.UNCHANGED.getValue());
                }
            }
        } else if (this.isValidSpeed(maxSpeed) && maxSpeed > 50.0 || this.avoidHighwayTags.contains(highway)) {
            if (way.hasTag("sidewalk", (Collection<String>)this.sidewalksNoValues)) {
                weightToPrioMap.put(45.0, PriorityCode.WORST.getValue());
            } else {
                weightToPrioMap.put(45.0, PriorityCode.REACH_DEST.getValue());
            }
        }
        if (way.hasTag("bicycle", (Object)"official") || way.hasTag("bicycle", (Object)"designated")) {
            weightToPrioMap.put(44.0, PriorityCode.AVOID_IF_POSSIBLE.getValue());
        }
    }

    @Override
    public void applyWayTags(ReaderWay way, EdgeIteratorState edge) {
        PointList pl = edge.fetchWayGeometry(FetchMode.ALL);
        if (!pl.is3D()) {
            return;
        }
        if (way.hasTag("tunnel", (Object)"yes") || way.hasTag("bridge", (Object)"yes") || way.hasTag("highway", (Object)"steps")) {
            return;
        }
        double prevEle = pl.getElevation(0);
        double fullDistance = edge.getDistance();
        if (fullDistance < 2.0) {
            return;
        }
        double eleDelta = Math.abs(pl.getElevation(pl.size() - 1) - prevEle);
        double slope = eleDelta / fullDistance;
        IntsRef edgeFlags = edge.getFlags();
        if ((this.accessEnc.getBool(false, edgeFlags) || this.accessEnc.getBool(true, edgeFlags)) && slope > 0.005) {
            double newSpeed = Math.sqrt(1.0 + slope * slope) / (slope + 0.18518518518518517);
            edge.set(this.avgSpeedEnc, Helper.keepIn(newSpeed, 1.0, 5.0));
        }
    }

    @Override
    public boolean supports(Class<?> feature) {
        if (super.supports(feature)) {
            return true;
        }
        return PriorityWeighting.class.isAssignableFrom(feature);
    }

    @Override
    public String toString() {
        return "hike";
    }
}

