/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.carrotsearch.hppc.cursors.IntCursor;
import com.graphhopper.GHRequest;
import com.graphhopper.GHResponse;
import com.graphhopper.ResponsePath;
import com.graphhopper.config.Profile;
import com.graphhopper.routing.AlgorithmOptions;
import com.graphhopper.routing.CHPathCalculator;
import com.graphhopper.routing.FlexiblePathCalculator;
import com.graphhopper.routing.MultiplePointsNotFoundException;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.PathCalculator;
import com.graphhopper.routing.RoundTripRouting;
import com.graphhopper.routing.RouterConfig;
import com.graphhopper.routing.RoutingAlgorithmFactory;
import com.graphhopper.routing.RoutingAlgorithmFactorySimple;
import com.graphhopper.routing.ViaRouting;
import com.graphhopper.routing.WeightingFactory;
import com.graphhopper.routing.ch.CHRoutingAlgorithmFactory;
import com.graphhopper.routing.lm.LMRoutingAlgorithmFactory;
import com.graphhopper.routing.lm.LandmarkStorage;
import com.graphhopper.routing.querygraph.QueryGraph;
import com.graphhopper.routing.util.DefaultEdgeFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.BlockAreaWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.CHGraph;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.GraphEdgeIdFinder;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.storage.RoutingCHGraph;
import com.graphhopper.storage.RoutingCHGraphImpl;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.Snap;
import com.graphhopper.util.DistanceCalcEarth;
import com.graphhopper.util.DouglasPeucker;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;
import com.graphhopper.util.PathMerger;
import com.graphhopper.util.PointList;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.TranslationMap;
import com.graphhopper.util.details.PathDetailsBuilderFactory;
import com.graphhopper.util.exceptions.PointDistanceExceededException;
import com.graphhopper.util.exceptions.PointNotFoundException;
import com.graphhopper.util.exceptions.PointOutOfBoundsException;
import com.graphhopper.util.shapes.BBox;
import com.graphhopper.util.shapes.GHPoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Router {
    private final GraphHopperStorage ghStorage;
    private final EncodingManager encodingManager;
    private final LocationIndex locationIndex;
    private final Map<String, Profile> profilesByName;
    private final PathDetailsBuilderFactory pathDetailsBuilderFactory;
    private final TranslationMap translationMap;
    private final RouterConfig routerConfig;
    private final WeightingFactory weightingFactory;
    private final Map<String, RoutingCHGraph> chGraphs;
    private final Map<String, LandmarkStorage> landmarks;
    private final boolean chEnabled;
    private final boolean lmEnabled;

    public Router(GraphHopperStorage ghStorage, LocationIndex locationIndex, Map<String, Profile> profilesByName, PathDetailsBuilderFactory pathDetailsBuilderFactory, TranslationMap translationMap, RouterConfig routerConfig, WeightingFactory weightingFactory, Map<String, CHGraph> chGraphs, Map<String, LandmarkStorage> landmarks) {
        this.ghStorage = ghStorage;
        this.encodingManager = ghStorage.getEncodingManager();
        this.locationIndex = locationIndex;
        this.profilesByName = profilesByName;
        this.pathDetailsBuilderFactory = pathDetailsBuilderFactory;
        this.translationMap = translationMap;
        this.routerConfig = routerConfig;
        this.weightingFactory = weightingFactory;
        this.chGraphs = new LinkedHashMap<String, RoutingCHGraph>(chGraphs.size());
        for (Map.Entry<String, CHGraph> e : chGraphs.entrySet()) {
            this.chGraphs.put(e.getKey(), new RoutingCHGraphImpl(e.getValue()));
        }
        this.landmarks = landmarks;
        this.chEnabled = !chGraphs.isEmpty();
        this.lmEnabled = !landmarks.isEmpty();
    }

    public GHResponse route(GHRequest request) {
        try {
            this.validateRequest(request);
            boolean disableCH = Router.getDisableCH(request.getHints());
            boolean disableLM = Router.getDisableLM(request.getHints());
            Profile profile = this.profilesByName.get(request.getProfile());
            if (profile == null) {
                throw new IllegalArgumentException("The requested profile '" + request.getProfile() + "' does not exist.\nAvailable profiles: " + this.profilesByName.keySet());
            }
            if (!profile.isTurnCosts() && !request.getCurbsides().isEmpty()) {
                throw new IllegalArgumentException("To make use of the curbside parameter you need to use a profile that supports turn costs\nThe following profiles do support turn costs: " + this.getTurnCostProfiles());
            }
            TraversalMode traversalMode = profile.isTurnCosts() ? TraversalMode.EDGE_BASED : TraversalMode.NODE_BASED;
            int uTurnCostsInt = request.getHints().getInt("u_turn_costs", -1);
            if (uTurnCostsInt != -1 && !traversalMode.isEdgeBased()) {
                throw new IllegalArgumentException("Finite u-turn costs can only be used for edge-based routing, you need to use a profile that supports turn costs. Currently the following profiles that support turn costs are available: " + this.getTurnCostProfiles());
            }
            boolean passThrough = Router.getPassThrough(request.getHints());
            boolean forceCurbsides = request.getHints().getBool("force_curbside", true);
            int maxVisitedNodesForRequest = request.getHints().getInt("max_visited_nodes", this.routerConfig.getMaxVisitedNodes());
            if (maxVisitedNodesForRequest > this.routerConfig.getMaxVisitedNodes()) {
                throw new IllegalArgumentException("The max_visited_nodes parameter has to be below or equal to:" + this.routerConfig.getMaxVisitedNodes());
            }
            boolean useCH = this.chEnabled && !disableCH;
            Weighting weighting = this.createWeighting(profile, request.getHints(), request.getPoints(), useCH);
            AlgorithmOptions algoOpts = AlgorithmOptions.start().algorithm(request.getAlgorithm()).traversalMode(traversalMode).weighting(weighting).maxVisitedNodes(maxVisitedNodesForRequest).hints(request.getHints()).build();
            if ("round_trip".equalsIgnoreCase(request.getAlgorithm())) {
                return this.routeRoundTrip(request, algoOpts, weighting, profile, disableLM);
            }
            if ("alternative_route".equalsIgnoreCase(request.getAlgorithm())) {
                return this.routeAlt(request, algoOpts, weighting, profile, passThrough, forceCurbsides, disableCH, disableLM);
            }
            return this.routeVia(request, algoOpts, weighting, profile, passThrough, forceCurbsides, disableCH, disableLM);
        }
        catch (MultiplePointsNotFoundException ex) {
            GHResponse ghRsp = new GHResponse();
            for (IntCursor p : ex.getPointsNotFound()) {
                ghRsp.addError(new PointNotFoundException("Cannot find point " + p.value + ": " + request.getPoints().get(p.index), p.value));
            }
            return ghRsp;
        }
        catch (IllegalArgumentException ex) {
            GHResponse ghRsp = new GHResponse();
            ghRsp.addError(ex);
            return ghRsp;
        }
    }

    protected GHResponse routeRoundTrip(GHRequest request, AlgorithmOptions algoOpts, Weighting weighting, Profile profile, boolean disableLM) {
        GHResponse ghRsp = new GHResponse();
        StopWatch sw = new StopWatch().start();
        double startHeading = request.getHeadings().isEmpty() ? Double.NaN : request.getHeadings().get(0);
        RoundTripRouting.Params params = new RoundTripRouting.Params(request.getHints(), startHeading, this.routerConfig.getMaxRoundTripRetries());
        List<Snap> qResults = RoundTripRouting.lookup(request.getPoints(), weighting, this.locationIndex, params);
        ghRsp.addDebugInfo("idLookup:" + sw.stop().getSeconds() + "s");
        AlgorithmOptions roundTripAlgoOpts = AlgorithmOptions.start(algoOpts).algorithm("astarbi").build();
        roundTripAlgoOpts.getHints().putObject("astarbi.epsilon", 2);
        QueryGraph queryGraph = QueryGraph.create((Graph)this.ghStorage, qResults);
        FlexiblePathCalculator pathCalculator = this.createFlexiblePathCalculator(queryGraph, profile, roundTripAlgoOpts, disableLM);
        RoundTripRouting.Result result = RoundTripRouting.calcPaths(qResults, pathCalculator);
        ResponsePath responsePath = this.concatenatePaths(request, weighting, queryGraph, result.paths, this.getWaypoints(qResults));
        ghRsp.add(responsePath);
        ghRsp.getHints().putObject("visited_nodes.sum", result.visitedNodes);
        ghRsp.getHints().putObject("visited_nodes.average", Float.valueOf((float)result.visitedNodes / (float)(qResults.size() - 1)));
        return ghRsp;
    }

    protected GHResponse routeAlt(GHRequest request, AlgorithmOptions algoOpts, Weighting weighting, Profile profile, boolean passThrough, boolean forceCurbsides, boolean disableCH, boolean disableLM) {
        if (request.getPoints().size() > 2) {
            throw new IllegalArgumentException("Currently alternative routes work only with start and end point. You tried to use: " + request.getPoints().size() + " points");
        }
        GHResponse ghRsp = new GHResponse();
        StopWatch sw = new StopWatch().start();
        List<Snap> qResults = ViaRouting.lookup(this.encodingManager, request.getPoints(), weighting, this.locationIndex, request.getSnapPreventions(), request.getPointHints());
        ghRsp.addDebugInfo("idLookup:" + sw.stop().getSeconds() + "s");
        QueryGraph queryGraph = QueryGraph.create((Graph)this.ghStorage, qResults);
        PathCalculator pathCalculator = this.createPathCalculator(queryGraph, profile, algoOpts, disableCH, disableLM);
        if (passThrough) {
            throw new IllegalArgumentException("Alternative paths and pass_through at the same time is currently not supported");
        }
        if (!request.getCurbsides().isEmpty()) {
            throw new IllegalArgumentException("Alternative paths do not support the curbside parameter yet");
        }
        ViaRouting.Result result = ViaRouting.calcPaths(request.getPoints(), queryGraph, qResults, weighting.getFlagEncoder().getAccessEnc(), pathCalculator, request.getCurbsides(), forceCurbsides, request.getHeadings(), passThrough);
        if (result.paths.isEmpty()) {
            throw new RuntimeException("Empty paths for alternative route calculation not expected");
        }
        PathMerger pathMerger = this.createPathMerger(request, weighting, queryGraph);
        for (Path path : result.paths) {
            PointList waypoints = this.getWaypoints(qResults);
            ResponsePath responsePath = pathMerger.doWork(waypoints, Collections.singletonList(path), this.encodingManager, this.translationMap.getWithFallBack(request.getLocale()));
            ghRsp.add(responsePath);
        }
        ghRsp.getHints().putObject("visited_nodes.sum", result.visitedNodes);
        ghRsp.getHints().putObject("visited_nodes.average", Float.valueOf((float)result.visitedNodes / (float)(qResults.size() - 1)));
        return ghRsp;
    }

    protected GHResponse routeVia(GHRequest request, AlgorithmOptions algoOpts, Weighting weighting, Profile profile, boolean passThrough, boolean forceCurbsides, boolean disableCH, boolean disableLM) {
        GHResponse ghRsp = new GHResponse();
        StopWatch sw = new StopWatch().start();
        List<Snap> qResults = ViaRouting.lookup(this.encodingManager, request.getPoints(), weighting, this.locationIndex, request.getSnapPreventions(), request.getPointHints());
        ghRsp.addDebugInfo("idLookup:" + sw.stop().getSeconds() + "s");
        QueryGraph queryGraph = QueryGraph.create((Graph)this.ghStorage, qResults);
        PathCalculator pathCalculator = this.createPathCalculator(queryGraph, profile, algoOpts, disableCH, disableLM);
        ViaRouting.Result result = ViaRouting.calcPaths(request.getPoints(), queryGraph, qResults, weighting.getFlagEncoder().getAccessEnc(), pathCalculator, request.getCurbsides(), forceCurbsides, request.getHeadings(), passThrough);
        if (request.getPoints().size() != result.paths.size() + 1) {
            throw new RuntimeException("There should be exactly one more point than paths. points:" + request.getPoints().size() + ", paths:" + result.paths.size());
        }
        ResponsePath responsePath = this.concatenatePaths(request, weighting, queryGraph, result.paths, this.getWaypoints(qResults));
        responsePath.addDebugInfo(result.debug);
        ghRsp.add(responsePath);
        ghRsp.getHints().putObject("visited_nodes.sum", result.visitedNodes);
        ghRsp.getHints().putObject("visited_nodes.average", Float.valueOf((float)result.visitedNodes / (float)(qResults.size() - 1)));
        return ghRsp;
    }

    private Weighting createWeighting(Profile profile, PMap requestHints, List<GHPoint> points, boolean forCH) {
        if (forCH) {
            return this.weightingFactory.createWeighting(profile, new PMap(), false);
        }
        Weighting weighting = this.weightingFactory.createWeighting(profile, requestHints, false);
        if (requestHints.has("block_area")) {
            FlagEncoder encoder = this.encodingManager.getEncoder(profile.getVehicle());
            GraphEdgeIdFinder.BlockArea blockArea = GraphEdgeIdFinder.createBlockArea(this.ghStorage, this.locationIndex, points, requestHints, DefaultEdgeFilter.allEdges(encoder));
            weighting = new BlockAreaWeighting(weighting, blockArea);
        }
        return weighting;
    }

    private PathCalculator createPathCalculator(QueryGraph queryGraph, Profile profile, AlgorithmOptions algoOpts, boolean disableCH, boolean disableLM) {
        if (this.chEnabled && !disableCH) {
            PMap opts = new PMap(algoOpts.getHints());
            opts.putObject("algorithm", algoOpts.getAlgorithm());
            opts.putObject("max_visited_nodes", algoOpts.getMaxVisitedNodes());
            return this.createCHPathCalculator(queryGraph, profile, opts);
        }
        return this.createFlexiblePathCalculator(queryGraph, profile, algoOpts, disableLM);
    }

    private PathCalculator createCHPathCalculator(QueryGraph queryGraph, Profile profile, PMap opts) {
        RoutingCHGraph chGraph = this.chGraphs.get(profile.getName());
        if (chGraph == null) {
            throw new IllegalArgumentException("Cannot find CH preparation for the requested profile: '" + profile.getName() + "'\nYou can try disabling CH using " + "ch.disable" + "=true\navailable CH profiles: " + this.chGraphs.keySet());
        }
        return new CHPathCalculator(new CHRoutingAlgorithmFactory(chGraph, queryGraph), opts);
    }

    private FlexiblePathCalculator createFlexiblePathCalculator(QueryGraph queryGraph, Profile profile, AlgorithmOptions algoOpts, boolean disableLM) {
        RoutingAlgorithmFactory algorithmFactory;
        if (this.lmEnabled && !disableLM) {
            LandmarkStorage landmarkStorage = this.landmarks.get(profile.getName());
            if (landmarkStorage == null) {
                throw new IllegalArgumentException("Cannot find LM preparation for the requested profile: '" + profile.getName() + "'\nYou can try disabling LM using " + "lm.disable" + "=true\navailable LM profiles: " + this.landmarks.keySet());
            }
            algorithmFactory = new LMRoutingAlgorithmFactory(landmarkStorage).setDefaultActiveLandmarks(this.routerConfig.getActiveLandmarkCount());
        } else {
            algorithmFactory = new RoutingAlgorithmFactorySimple();
        }
        return new FlexiblePathCalculator(queryGraph, algorithmFactory, algoOpts);
    }

    private PathMerger createPathMerger(GHRequest request, Weighting weighting, Graph graph) {
        boolean enableInstructions = request.getHints().getBool("instructions", this.encodingManager.isEnableInstructions());
        boolean calcPoints = request.getHints().getBool("calc_points", this.routerConfig.isCalcPoints());
        double wayPointMaxDistance = request.getHints().getDouble("way_point_max_distance", 1.0);
        double elevationWayPointMaxDistance = request.getHints().getDouble("elevation_way_point_max_distance", this.routerConfig.getElevationWayPointMaxDistance());
        DouglasPeucker peucker = new DouglasPeucker().setMaxDistance(wayPointMaxDistance).setElevationMaxDistance(elevationWayPointMaxDistance);
        PathMerger pathMerger = new PathMerger(graph, weighting).setCalcPoints(calcPoints).setDouglasPeucker(peucker).setEnableInstructions(enableInstructions).setPathDetailsBuilders(this.pathDetailsBuilderFactory, request.getPathDetails()).setSimplifyResponse(this.routerConfig.isSimplifyResponse() && wayPointMaxDistance > 0.0);
        if (!request.getHeadings().isEmpty()) {
            pathMerger.setFavoredHeading(request.getHeadings().get(0));
        }
        return pathMerger;
    }

    private ResponsePath concatenatePaths(GHRequest request, Weighting weighting, QueryGraph queryGraph, List<Path> paths, PointList waypoints) {
        PathMerger pathMerger = this.createPathMerger(request, weighting, queryGraph);
        return pathMerger.doWork(waypoints, paths, this.encodingManager, this.translationMap.getWithFallBack(request.getLocale()));
    }

    private PointList getWaypoints(List<Snap> snaps) {
        PointList pointList = new PointList(snaps.size(), true);
        for (Snap snap : snaps) {
            pointList.add(snap.getSnappedPoint());
        }
        return pointList;
    }

    protected void validateRequest(GHRequest request) {
        if (Helper.isEmpty(request.getProfile())) {
            throw new IllegalArgumentException("You need to specify a profile to perform a routing request, see docs/core/profiles.md");
        }
        if (request.getHints().has("vehicle")) {
            throw new IllegalArgumentException("GHRequest may no longer contain a vehicle, use the profile parameter instead, see docs/core/profiles.md");
        }
        if (request.getHints().has("weighting")) {
            throw new IllegalArgumentException("GHRequest may no longer contain a weighting, use the profile parameter instead, see docs/core/profiles.md");
        }
        if (request.getHints().has("turn_costs")) {
            throw new IllegalArgumentException("GHRequest may no longer contain the turn_costs=true/false parameter, use the profile parameter instead, see docs/core/profiles.md");
        }
        if (request.getHints().has("edge_based")) {
            throw new IllegalArgumentException("GHRequest may no longer contain the edge_based=true/false parameter, use the profile parameter instead, see docs/core/profiles.md");
        }
        if (request.getPoints().isEmpty()) {
            throw new IllegalArgumentException("You have to pass at least one point");
        }
        this.checkIfPointsAreInBounds(request.getPoints());
        if (request.getHeadings().size() > 1 && request.getHeadings().size() != request.getPoints().size()) {
            throw new IllegalArgumentException("The number of 'heading' parameters must be zero, one or equal to the number of points (" + request.getPoints().size() + ")");
        }
        for (int i = 0; i < request.getHeadings().size(); ++i) {
            if (GHRequest.isAzimuthValue(request.getHeadings().get(i))) continue;
            throw new IllegalArgumentException("Heading for point " + i + " must be in range [0,360) or NaN, but was: " + request.getHeadings().get(i));
        }
        if (request.getPointHints().size() > 0 && request.getPointHints().size() != request.getPoints().size()) {
            throw new IllegalArgumentException("If you pass point_hint, you need to pass exactly one hint for every point, empty hints will be ignored");
        }
        if (request.getCurbsides().size() > 0 && request.getCurbsides().size() != request.getPoints().size()) {
            throw new IllegalArgumentException("If you pass curbside, you need to pass exactly one curbside for every point, empty curbsides will be ignored");
        }
        boolean disableCH = Router.getDisableCH(request.getHints());
        if (this.chEnabled && !this.routerConfig.isCHDisablingAllowed() && disableCH) {
            throw new IllegalArgumentException("Disabling CH not allowed on the server-side");
        }
        boolean disableLM = Router.getDisableLM(request.getHints());
        if (this.lmEnabled && !this.routerConfig.isLMDisablingAllowed() && disableLM) {
            throw new IllegalArgumentException("Disabling LM not allowed on the server-side");
        }
        if (this.chEnabled && !disableCH) {
            if (!request.getHeadings().isEmpty()) {
                throw new IllegalArgumentException("The 'heading' parameter is currently not supported for speed mode, you need to disable speed mode with `ch.disable=true`. See issue #483");
            }
            if (Router.getPassThrough(request.getHints())) {
                throw new IllegalArgumentException("The 'pass_through' parameter is currently not supported for speed mode, you need to disable speed mode with `ch.disable=true`. See issue #1765");
            }
            if (request.getHints().has("block_area")) {
                throw new IllegalArgumentException("When CH is enabled the block_area cannot be specified");
            }
        } else {
            this.checkNonChMaxWaypointDistance(request.getPoints());
        }
    }

    private List<String> getTurnCostProfiles() {
        ArrayList<String> turnCostProfiles = new ArrayList<String>();
        for (Profile p : this.profilesByName.values()) {
            if (!p.isTurnCosts()) continue;
            turnCostProfiles.add(p.getName());
        }
        return turnCostProfiles;
    }

    private static boolean getDisableLM(PMap hints) {
        return hints.getBool("lm.disable", false);
    }

    private static boolean getDisableCH(PMap hints) {
        return hints.getBool("ch.disable", false);
    }

    private static boolean getPassThrough(PMap hints) {
        return hints.getBool("pass_through", false);
    }

    private void checkIfPointsAreInBounds(List<GHPoint> points) {
        BBox bounds = this.ghStorage.getBounds();
        for (int i = 0; i < points.size(); ++i) {
            GHPoint point = points.get(i);
            if (bounds.contains(point.getLat(), point.getLon())) continue;
            throw new PointOutOfBoundsException("Point " + i + " is out of bounds: " + point + ", the bounds are: " + bounds, i);
        }
    }

    private void checkNonChMaxWaypointDistance(List<GHPoint> points) {
        if (this.routerConfig.getNonChMaxWaypointDistance() == Integer.MAX_VALUE) {
            return;
        }
        GHPoint lastPoint = points.get(0);
        for (int i = 1; i < points.size(); ++i) {
            GHPoint point = points.get(i);
            double dist = DistanceCalcEarth.DIST_EARTH.calcDist(lastPoint.getLat(), lastPoint.getLon(), point.getLat(), point.getLon());
            if (dist > (double)this.routerConfig.getNonChMaxWaypointDistance()) {
                HashMap<String, Object> detailMap = new HashMap<String, Object>(2);
                detailMap.put("from", i - 1);
                detailMap.put("to", i);
                throw new PointDistanceExceededException("Point " + i + " is too far from Point " + (i - 1) + ": " + point, detailMap);
            }
            lastPoint = point;
        }
    }
}

