/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.carrotsearch.hppc.IntHashSet;
import com.carrotsearch.hppc.IntSet;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.graphhopper.routing.AlgorithmOptions;
import com.graphhopper.routing.EdgeRestrictions;
import com.graphhopper.routing.FlexiblePathCalculator;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.ViaRouting;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.tour.MultiPointTour;
import com.graphhopper.routing.util.tour.TourStrategy;
import com.graphhopper.routing.weighting.AvoidEdgesWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.Snap;
import com.graphhopper.util.DistanceCalcEarth;
import com.graphhopper.util.PMap;
import com.graphhopper.util.exceptions.PointNotFoundException;
import com.graphhopper.util.shapes.GHPoint;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class RoundTripRouting {
    public static List<Snap> lookup(List<GHPoint> points, Weighting weighting, LocationIndex locationIndex, Params params) {
        EdgeFilter edgeFilter = ViaRouting.createEdgeFilter(weighting);
        if (points.size() != 1) {
            throw new IllegalArgumentException("For round trip calculation exactly one point is required");
        }
        GHPoint start = points.get(0);
        MultiPointTour strategy = new MultiPointTour(new Random(params.seed), params.distanceInMeter, params.roundTripPointCount, params.initialHeading);
        ArrayList<Snap> snaps = new ArrayList<Snap>(2 + ((TourStrategy)strategy).getNumberOfGeneratedPoints());
        Snap startSnap = locationIndex.findClosest(start.lat, start.lon, edgeFilter);
        if (!startSnap.isValid()) {
            throw new PointNotFoundException("Cannot find point 0: " + start, 0);
        }
        snaps.add(startSnap);
        GHPoint last = start;
        for (int i = 0; i < ((TourStrategy)strategy).getNumberOfGeneratedPoints(); ++i) {
            double heading = ((TourStrategy)strategy).getHeadingForIteration(i);
            Snap result = RoundTripRouting.generateValidPoint(last, ((TourStrategy)strategy).getDistanceForIteration(i), heading, edgeFilter, locationIndex, params.maxRetries);
            last = result.getSnappedPoint();
            snaps.add(result);
        }
        snaps.add(startSnap);
        return snaps;
    }

    private static Snap generateValidPoint(GHPoint lastPoint, double distanceInMeters, double heading, EdgeFilter edgeFilter, LocationIndex locationIndex, int maxRetries) {
        int tryCount = 0;
        do {
            GHPoint generatedPoint;
            Snap snap;
            if ((snap = locationIndex.findClosest((generatedPoint = DistanceCalcEarth.DIST_EARTH.projectCoordinate(lastPoint.getLat(), lastPoint.getLon(), distanceInMeters, heading)).getLat(), generatedPoint.getLon(), edgeFilter)).isValid()) {
                return snap;
            }
            distanceInMeters *= 0.95;
        } while (++tryCount < maxRetries);
        throw new IllegalArgumentException("Could not find a valid point after " + maxRetries + " tries, for the point:" + lastPoint);
    }

    public static Result calcPaths(List<Snap> snaps, FlexiblePathCalculator pathCalculator) {
        RoundTripCalculator roundTripCalculator = new RoundTripCalculator(pathCalculator);
        Result result = new Result(snaps.size() - 1);
        Snap start = snaps.get(0);
        for (int snapIndex = 1; snapIndex < snaps.size(); ++snapIndex) {
            Snap startSnap = snaps.get(snapIndex - 1);
            int startNode = startSnap == start ? startSnap.getClosestNode() : startSnap.getClosestEdge().getBaseNode();
            Snap endSnap = snaps.get(snapIndex);
            int endNode = endSnap == start ? endSnap.getClosestNode() : endSnap.getClosestEdge().getBaseNode();
            Path path = roundTripCalculator.calcPath(startNode, endNode);
            result.visitedNodes += (long)pathCalculator.getVisitedNodes();
            result.paths.add(path);
        }
        return result;
    }

    private static class RoundTripCalculator {
        private final FlexiblePathCalculator pathCalculator;
        private final IntSet previousEdges = new IntHashSet();

        RoundTripCalculator(FlexiblePathCalculator pathCalculator) {
            this.pathCalculator = pathCalculator;
            AvoidEdgesWeighting avoidPreviousPathsWeighting = new AvoidEdgesWeighting(pathCalculator.getAlgoOpts().getWeighting()).setEdgePenaltyFactor(5.0);
            avoidPreviousPathsWeighting.setAvoidedEdges(this.previousEdges);
            AlgorithmOptions algoOpts = AlgorithmOptions.start(pathCalculator.getAlgoOpts()).weighting(avoidPreviousPathsWeighting).build();
            pathCalculator.setAlgoOpts(algoOpts);
        }

        Path calcPath(int from, int to) {
            Path path = this.pathCalculator.calcPaths(from, to, new EdgeRestrictions()).get(0);
            for (IntCursor c : path.getEdges()) {
                this.previousEdges.add(c.value);
            }
            return path;
        }
    }

    public static class Result {
        public List<Path> paths;
        public long visitedNodes;

        Result(int legs) {
            this.paths = new ArrayList<Path>(legs);
        }
    }

    public static class Params {
        final double distanceInMeter;
        final long seed;
        final double initialHeading;
        final int roundTripPointCount;
        final int maxRetries;

        public Params() {
            this(new PMap(), 0.0, 3);
        }

        public Params(PMap hints, double initialHeading, int maxRetries) {
            this.distanceInMeter = hints.getDouble("round_trip.distance", 10000.0);
            this.seed = hints.getLong("round_trip.seed", 0L);
            this.roundTripPointCount = Math.min(20, hints.getInt("round_trip.points", 2 + (int)(this.distanceInMeter / 50000.0)));
            this.initialHeading = initialHeading;
            this.maxRetries = maxRetries;
        }
    }
}

