/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.graphhopper.routing.AbstractBidirectionEdgeCHNoSOD;
import com.graphhopper.routing.SPTEntry;
import com.graphhopper.routing.ch.AStarCHEntry;
import com.graphhopper.routing.weighting.BalancedWeightApproximator;
import com.graphhopper.routing.weighting.BeelineWeightApproximator;
import com.graphhopper.routing.weighting.WeightApproximator;
import com.graphhopper.storage.RoutingCHGraph;
import com.graphhopper.util.DistancePlaneProjection;

public class AStarBidirectionEdgeCHNoSOD
extends AbstractBidirectionEdgeCHNoSOD {
    private final boolean useHeuristicForNodeOrder = false;
    private BalancedWeightApproximator weightApprox;

    public AStarBidirectionEdgeCHNoSOD(RoutingCHGraph graph) {
        super(graph);
        this.setApproximation(new BeelineWeightApproximator(this.nodeAccess, graph.getWeighting()).setDistanceCalc(DistancePlaneProjection.DIST_PLANE));
    }

    @Override
    public void init(int from, double fromWeight, int to, double toWeight) {
        this.weightApprox.setFromTo(from, to);
        super.init(from, fromWeight, to, toWeight);
    }

    @Override
    protected boolean fwdSearchCanBeStopped() {
        return this.getMinCurrFromPathWeight() > this.bestWeight;
    }

    @Override
    protected boolean bwdSearchCanBeStopped() {
        return this.getMinCurrToPathWeight() > this.bestWeight;
    }

    @Override
    protected AStarCHEntry createStartEntry(int node, double weight, boolean reverse) {
        double heapWeight = this.getHeapWeight(node, reverse, weight);
        return new AStarCHEntry(node, heapWeight, weight);
    }

    @Override
    protected SPTEntry createEntry(int edge, int adjNode, int incEdge, double weight, SPTEntry parent, boolean reverse) {
        double heapWeight = this.getHeapWeight(adjNode, reverse, weight);
        AStarCHEntry entry = new AStarCHEntry(edge, incEdge, adjNode, heapWeight, weight);
        entry.parent = parent;
        return entry;
    }

    @Override
    protected void updateEntry(SPTEntry entry, int edge, int adjNode, int incEdge, double weight, SPTEntry parent, boolean reverse) {
        entry.edge = edge;
        ((AStarCHEntry)entry).incEdge = incEdge;
        entry.weight = this.getHeapWeight(adjNode, reverse, weight);
        ((AStarCHEntry)entry).weightOfVisitedPath = weight;
        entry.parent = parent;
    }

    public WeightApproximator getApproximation() {
        return this.weightApprox.getApproximation();
    }

    public AStarBidirectionEdgeCHNoSOD setApproximation(WeightApproximator weightApproximator) {
        this.weightApprox = new BalancedWeightApproximator(weightApproximator);
        return this;
    }

    private double getHeapWeight(int node, boolean reverse, double weightOfVisitedPath) {
        return weightOfVisitedPath;
    }

    private double getMinCurrFromPathWeight() {
        return this.currFrom.weight + this.weightApprox.approximate(this.currFrom.adjNode, false);
    }

    private double getMinCurrToPathWeight() {
        return this.currTo.weight + this.weightApprox.approximate(this.currTo.adjNode, true);
    }

    @Override
    public String getName() {
        return "astarbi|ch|edge_based|no_sod";
    }
}

