/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.gtfs;

import com.graphhopper.gtfs.GtfsStorage;
import com.graphhopper.gtfs.GtfsStorageI;
import com.graphhopper.gtfs.PtEncodedValues;
import com.graphhopper.gtfs.RealtimeFeed;
import com.graphhopper.storage.Graph;
import com.graphhopper.util.EdgeIteratorState;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Label {
    public final long currentTime;
    public final int edge;
    public final int adjNode;
    public final int nTransfers;
    public final double walkDistanceOnCurrentLeg;
    public final Long departureTime;
    public final long walkTime;
    final long residualDelay;
    final boolean impossible;
    public final Label parent;

    Label(long currentTime, int edgeId, int adjNode, int nTransfers, double walkDistance, Long departureTime, long walkTime, long residualDelay, boolean impossible, Label parent) {
        this.currentTime = currentTime;
        this.edge = edgeId;
        this.adjNode = adjNode;
        this.nTransfers = nTransfers;
        this.walkDistanceOnCurrentLeg = walkDistance;
        this.departureTime = departureTime;
        this.walkTime = walkTime;
        this.residualDelay = residualDelay;
        this.impossible = impossible;
        this.parent = parent;
    }

    public String toString() {
        return this.adjNode + " " + (this.departureTime != null ? Instant.ofEpochMilli(this.departureTime) : "---") + "\t" + this.nTransfers + "\t" + Instant.ofEpochMilli(this.currentTime);
    }

    static List<Transition> getTransitions(Label _label, boolean arriveBy, PtEncodedValues encoder, Graph queryGraph, RealtimeFeed realtimeFeed) {
        Label label = _label;
        boolean reverseEdgeFlags = !arriveBy;
        ArrayList<Transition> result = new ArrayList<Transition>();
        if (!reverseEdgeFlags) {
            result.add(new Transition(label, null));
        }
        while (label.parent != null) {
            EdgeIteratorState edgeIteratorState = queryGraph.getEdgeIteratorState(label.edge, reverseEdgeFlags ? label.adjNode : label.parent.adjNode).detach(false);
            if (reverseEdgeFlags && edgeIteratorState != null && (edgeIteratorState.getBaseNode() != label.parent.adjNode || edgeIteratorState.getAdjNode() != label.adjNode)) {
                throw new IllegalStateException();
            }
            if (!(reverseEdgeFlags || edgeIteratorState == null || edgeIteratorState.getAdjNode() == label.parent.adjNode && edgeIteratorState.getBaseNode() == label.adjNode)) {
                throw new IllegalStateException();
            }
            Transition transition = reverseEdgeFlags ? new Transition(label, edgeIteratorState != null ? Label.getEdgeLabel(edgeIteratorState, encoder, realtimeFeed) : null) : new Transition(label.parent, edgeIteratorState != null ? Label.getEdgeLabel(edgeIteratorState, encoder, realtimeFeed) : null);
            label = label.parent;
            result.add(transition);
        }
        if (reverseEdgeFlags) {
            result.add(new Transition(label, null));
            Collections.reverse(result);
        }
        return result;
    }

    public static EdgeLabel getEdgeLabel(EdgeIteratorState edgeIteratorState, PtEncodedValues flagEncoder, RealtimeFeed realtimeFeed) {
        String feedId;
        GtfsStorage.EdgeType edgeType = edgeIteratorState.get(flagEncoder.getTypeEnc());
        if (edgeType == GtfsStorage.EdgeType.ENTER_PT || edgeType == GtfsStorage.EdgeType.TRANSFER) {
            GtfsStorageI.PlatformDescriptor platformDescriptor = realtimeFeed.getPlatformDescriptorByEdge().get(edgeIteratorState.getEdge());
            feedId = platformDescriptor.feed_id;
        } else {
            feedId = null;
        }
        int nTransfers = edgeIteratorState.get(flagEncoder.getTransfersEnc());
        double distance = edgeIteratorState.getDistance();
        return new EdgeLabel(edgeIteratorState, edgeType, feedId, nTransfers, distance);
    }

    public static class EdgeLabel {
        public final EdgeIteratorState edgeIteratorState;
        public final GtfsStorage.EdgeType edgeType;
        public final String feedId;
        public final int nTransfers;
        public final double distance;

        public EdgeLabel(EdgeIteratorState edgeIteratorState, GtfsStorage.EdgeType edgeType, String feedId, int nTransfers, double distance) {
            this.edgeIteratorState = edgeIteratorState;
            this.edgeType = edgeType;
            this.feedId = feedId;
            this.nTransfers = nTransfers;
            this.distance = distance;
        }

        public String toString() {
            return this.edgeType.toString();
        }
    }

    static class Transition {
        final Label label;
        final EdgeLabel edge;

        Transition(Label label, EdgeLabel edge) {
            this.label = label;
            this.edge = edge;
        }

        public String toString() {
            return (this.edge != null ? this.edge.toString() + " -> " : "") + this.label.adjNode;
        }
    }
}

