/*
 * Decompiled with CFR 0.152.
 */
package com.conveyal.gtfs.model;

import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.model.Entity;
import java.io.IOException;
import java.net.URL;

public class Stop
extends Entity {
    private static final long serialVersionUID = 464065335273514677L;
    public String stop_id;
    public String stop_code;
    public String stop_name;
    public String stop_desc;
    public double stop_lat;
    public double stop_lon;
    public String zone_id;
    public URL stop_url;
    public int location_type;
    public String parent_station;
    public String stop_timezone;
    public String wheelchair_boarding;
    public String feed_id;

    public static class Loader
    extends Entity.Loader<Stop> {
        public Loader(GTFSFeed feed) {
            super(feed, "stops");
        }

        @Override
        protected boolean isRequired() {
            return true;
        }

        @Override
        public void loadOneRow() throws IOException {
            Stop s2 = new Stop();
            s2.sourceFileLine = this.row + 1L;
            s2.stop_id = this.getStringField("stop_id", true);
            s2.stop_code = this.getStringField("stop_code", false);
            s2.stop_name = this.getStringField("stop_name", true);
            s2.stop_desc = this.getStringField("stop_desc", false);
            s2.stop_lat = this.getDoubleField("stop_lat", true, -90.0, 90.0);
            s2.stop_lon = this.getDoubleField("stop_lon", true, -180.0, 180.0);
            s2.zone_id = this.getStringField("zone_id", false);
            s2.stop_url = this.getUrlField("stop_url", false);
            s2.location_type = this.getIntField("location_type", false, 0, 1);
            s2.parent_station = this.getStringField("parent_station", false);
            s2.stop_timezone = this.getStringField("stop_timezone", false);
            s2.wheelchair_boarding = this.getStringField("wheelchair_boarding", false);
            s2.feed = this.feed;
            s2.feed_id = this.feed.feedId;
            this.feed.stops.put(s2.stop_id, s2);
        }
    }
}

