/*
 * Decompiled with CFR 0.152.
 */
package com.conveyal.gtfs;

import com.conveyal.gtfs.error.GTFSError;
import com.conveyal.gtfs.error.GeneralError;
import com.conveyal.gtfs.model.Agency;
import com.conveyal.gtfs.model.Calendar;
import com.conveyal.gtfs.model.CalendarDate;
import com.conveyal.gtfs.model.Fare;
import com.conveyal.gtfs.model.FareAttribute;
import com.conveyal.gtfs.model.FareRule;
import com.conveyal.gtfs.model.FeedInfo;
import com.conveyal.gtfs.model.Frequency;
import com.conveyal.gtfs.model.Route;
import com.conveyal.gtfs.model.Service;
import com.conveyal.gtfs.model.Shape;
import com.conveyal.gtfs.model.ShapePoint;
import com.conveyal.gtfs.model.Stop;
import com.conveyal.gtfs.model.StopTime;
import com.conveyal.gtfs.model.Transfer;
import com.conveyal.gtfs.model.Trip;
import com.google.common.collect.Iterables;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableSet;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.mapdb.BTreeMap;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.Fun;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GTFSFeed
implements Cloneable,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(GTFSFeed.class);
    public static final double METERS_PER_DEGREE_LATITUDE = 111111.111;
    private DB db;
    public String feedId = null;
    public final Map<String, Agency> agency;
    public final Map<String, FeedInfo> feedInfo;
    public final NavigableSet<Fun.Tuple2<String, Frequency>> frequencies;
    public final Map<String, Route> routes;
    public final Map<String, Stop> stops;
    public final Map<String, Transfer> transfers;
    public final BTreeMap<String, Trip> trips;
    public long checksum;
    public final ConcurrentNavigableMap<Fun.Tuple2<String, Integer>, ShapePoint> shape_points;
    public final BTreeMap<Fun.Tuple2, StopTime> stop_times;
    public final Map<String, Fare> fares;
    public final BTreeMap<String, Service> services;
    public final NavigableSet<GTFSError> errors;
    private GeometryFactory gf = new GeometryFactory();
    private boolean loaded = false;

    public void loadFromFile(ZipFile zip, String fid) throws IOException {
        if (this.loaded) {
            throw new UnsupportedOperationException("Attempt to load GTFS into existing database");
        }
        this.checksum = zip.stream().mapToLong(ZipEntry::getCrc).reduce((l1, l2) -> l1 ^ l2).getAsLong();
        this.db.getAtomicLong("checksum").set(this.checksum);
        new FeedInfo.Loader(this).loadTable(zip);
        if (fid != null) {
            this.feedId = fid;
            LOG.info("Feed ID is undefined, pester maintainers to include a feed ID. Using file name {}.", (Object)this.feedId);
        } else if (this.feedId == null || this.feedId.isEmpty()) {
            this.feedId = new File(zip.getName()).getName().replaceAll("\\.zip$", "");
            LOG.info("Feed ID is undefined, pester maintainers to include a feed ID. Using file name {}.", (Object)this.feedId);
        } else {
            LOG.info("Feed ID is '{}'.", (Object)this.feedId);
        }
        this.db.getAtomicString("feed_id").set(this.feedId);
        new Agency.Loader(this).loadTable(zip);
        if (this.agency.isEmpty()) {
            this.errors.add(new GeneralError("agency", 0L, "agency_id", "Need at least one agency."));
        }
        HashMap<String, Service> serviceTable = new HashMap<String, Service>();
        new Calendar.Loader(this, serviceTable).loadTable(zip);
        new CalendarDate.Loader(this, serviceTable).loadTable(zip);
        this.services.putAll(serviceTable);
        serviceTable = null;
        HashMap<String, Fare> fares = new HashMap<String, Fare>();
        new FareAttribute.Loader(this, fares).loadTable(zip);
        new FareRule.Loader(this, fares).loadTable(zip);
        this.fares.putAll(fares);
        fares = null;
        new Route.Loader(this).loadTable(zip);
        new ShapePoint.Loader(this).loadTable(zip);
        new Stop.Loader(this).loadTable(zip);
        new Transfer.Loader(this).loadTable(zip);
        new Trip.Loader(this).loadTable(zip);
        new Frequency.Loader(this).loadTable(zip);
        new StopTime.Loader(this).loadTable(zip);
        this.loaded = true;
    }

    public void loadFromFileAndLogErrors(ZipFile zip) throws IOException {
        this.loadFromFile(zip, null);
        for (GTFSError error : this.errors) {
            LOG.error(error.getMessageWithContext());
        }
    }

    public boolean hasFeedInfo() {
        return !this.feedInfo.isEmpty();
    }

    public FeedInfo getFeedInfo() {
        return this.hasFeedInfo() ? this.feedInfo.values().iterator().next() : null;
    }

    public Iterable<StopTime> getOrderedStopTimesForTrip(String trip_id) {
        SortedMap tripStopTimes = this.stop_times.subMap((Object)Fun.t2(trip_id, null), (Object)Fun.t2(trip_id, Fun.HI));
        return tripStopTimes.values();
    }

    public Shape getShape(String shape_id) {
        Shape shape = new Shape(this, shape_id);
        return shape.shape_dist_traveled.length > 0 ? shape : null;
    }

    public Iterable<StopTime> getInterpolatedStopTimesForTrip(String trip_id) throws FirstAndLastStopsDoNotHaveTimes {
        StopTime[] stopTimes = (StopTime[])StreamSupport.stream(this.getOrderedStopTimesForTrip(trip_id).spliterator(), false).map(st -> st.clone()).toArray(StopTime[]::new);
        if (stopTimes.length == 0) {
            return Collections.emptyList();
        }
        for (StopTime st2 : stopTimes) {
            if (st2.arrival_time != Integer.MIN_VALUE && st2.departure_time == Integer.MIN_VALUE) {
                st2.departure_time = st2.arrival_time;
            }
            if (st2.arrival_time != Integer.MIN_VALUE || st2.departure_time == Integer.MIN_VALUE) continue;
            st2.arrival_time = st2.departure_time;
        }
        if (stopTimes[0].departure_time == Integer.MIN_VALUE || stopTimes[stopTimes.length - 1].departure_time == Integer.MIN_VALUE) {
            throw new FirstAndLastStopsDoNotHaveTimes();
        }
        int startOfInterpolatedBlock = -1;
        for (int stopTime = 0; stopTime < stopTimes.length; ++stopTime) {
            if (stopTimes[stopTime].departure_time == Integer.MIN_VALUE && startOfInterpolatedBlock == -1) {
                startOfInterpolatedBlock = stopTime;
                continue;
            }
            if (stopTimes[stopTime].departure_time == Integer.MIN_VALUE || startOfInterpolatedBlock == -1) continue;
            int nInterpolatedStops = stopTime - startOfInterpolatedBlock;
            double totalLengthOfInterpolatedSection = 0.0;
            double[] lengthOfInterpolatedSections = new double[nInterpolatedStops];
            int stopTimeToInterpolate = startOfInterpolatedBlock;
            int i = 0;
            while (stopTimeToInterpolate < stopTime) {
                Stop start = this.stops.get(stopTimes[stopTimeToInterpolate - 1].stop_id);
                Stop end = this.stops.get(stopTimes[stopTimeToInterpolate].stop_id);
                double segLen = GTFSFeed.fastDistance(start.stop_lat, start.stop_lon, end.stop_lat, end.stop_lon);
                totalLengthOfInterpolatedSection += segLen;
                lengthOfInterpolatedSections[i] = segLen;
                ++stopTimeToInterpolate;
                ++i;
            }
            Stop start = this.stops.get(stopTimes[stopTime - 1].stop_id);
            Stop end = this.stops.get(stopTimes[stopTime].stop_id);
            totalLengthOfInterpolatedSection += GTFSFeed.fastDistance(start.stop_lat, start.stop_lon, end.stop_lat, end.stop_lon);
            int departureBeforeInterpolation = stopTimes[startOfInterpolatedBlock - 1].departure_time;
            int arrivalAfterInterpolation = stopTimes[stopTime].arrival_time;
            int totalTime = arrivalAfterInterpolation - departureBeforeInterpolation;
            double lengthSoFar = 0.0;
            int stopTimeToInterpolate2 = startOfInterpolatedBlock;
            int i2 = 0;
            while (stopTimeToInterpolate2 < stopTime) {
                int time;
                stopTimes[stopTimeToInterpolate2].arrival_time = stopTimes[stopTimeToInterpolate2].departure_time = (time = (int)((double)departureBeforeInterpolation + (double)totalTime * ((lengthSoFar += lengthOfInterpolatedSections[i2]) / totalLengthOfInterpolatedSection)));
                ++stopTimeToInterpolate2;
                ++i2;
            }
            startOfInterpolatedBlock = -1;
        }
        return Arrays.asList(stopTimes);
    }

    public static double fastDistance(double lat0, double lon0, double lat1, double lon1) {
        double midLat = (lat0 + lat1) / 2.0;
        double xscale = Math.cos(Math.toRadians(midLat));
        double dx = xscale * (lon1 - lon0);
        double dy = lat1 - lat0;
        return Math.sqrt(dx * dx + dy * dy) * 111111.111;
    }

    public Collection<Frequency> getFrequencies(String trip_id) {
        return this.frequencies.subSet(new Fun.Tuple2<String, Object>(trip_id, null), new Fun.Tuple2<String, Object>(trip_id, Fun.HI)).stream().map(t2 -> (Frequency)((Fun.Tuple2)t2).b).collect(Collectors.toList());
    }

    public LineString getStraightLineForStops(String trip_id) {
        CoordinateList coordinates = new CoordinateList();
        LineString ls = null;
        Trip trip = this.trips.get(trip_id);
        Iterable<StopTime> stopTimes = this.getOrderedStopTimesForTrip(trip.trip_id);
        if (Iterables.size(stopTimes) > 1) {
            for (StopTime stopTime : stopTimes) {
                Stop stop = this.stops.get(stopTime.stop_id);
                Double lat = stop.stop_lat;
                Double lon = stop.stop_lon;
                coordinates.add(new Coordinate(lon, lat));
            }
            ls = this.gf.createLineString(coordinates.toCoordinateArray());
        } else {
            ls = null;
        }
        return ls;
    }

    public LineString getTripGeometry(String trip_id) {
        Shape shape;
        CoordinateList coordinates = new CoordinateList();
        LineString ls = null;
        Trip trip = this.trips.get(trip_id);
        if (trip.shape_id != null && (shape = this.getShape(trip.shape_id)) != null) {
            ls = shape.geometry;
        }
        if (ls == null) {
            ls = this.getStraightLineForStops(trip_id);
        }
        return ls;
    }

    public GTFSFeed clone() {
        try {
            return (GTFSFeed)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        this.db.close();
    }

    public GTFSFeed() {
        this(((DBMaker)((DBMaker)((DBMaker)((DBMaker)((DBMaker)DBMaker.newTempFileDB().transactionDisable()).mmapFileEnable()).asyncWriteEnable()).deleteFilesAfterClose()).compressionEnable()).make());
    }

    public GTFSFeed(File file) {
        this(GTFSFeed.constructDB(file));
    }

    private static DB constructDB(File file) {
        Object dbMaker = ((DBMaker)((DBMaker)((DBMaker)DBMaker.newFileDB(file).transactionDisable()).mmapFileEnable()).asyncWriteEnable()).compressionEnable();
        if (file.exists()) {
            ((DBMaker)dbMaker).readOnly();
        }
        return ((DBMaker)dbMaker).make();
    }

    private GTFSFeed(DB db) {
        this.db = db;
        this.agency = db.getTreeMap("agency");
        this.feedInfo = db.getTreeMap("feed_info");
        this.routes = db.getTreeMap("routes");
        this.trips = db.getTreeMap("trips");
        this.stop_times = db.getTreeMap("stop_times");
        this.frequencies = db.getTreeSet("frequencies");
        this.transfers = db.getTreeMap("transfers");
        this.stops = db.getTreeMap("stops");
        this.fares = db.getTreeMap("fares");
        this.services = db.getTreeMap("services");
        this.shape_points = db.getTreeMap("shape_points");
        this.feedId = db.getAtomicString("feed_id").get();
        this.checksum = db.getAtomicLong("checksum").get();
        this.errors = db.getTreeSet("errors");
    }

    public LocalDate getStartDate() {
        LocalDate startDate = null;
        if (this.hasFeedInfo()) {
            startDate = this.getFeedInfo().feed_start_date;
        }
        if (startDate == null) {
            startDate = this.getCalendarServiceRangeStart();
        }
        if (startDate == null) {
            startDate = this.getCalendarDateStart();
        }
        return startDate;
    }

    public LocalDate getCalendarServiceRangeStart() {
        int startDate = 0;
        for (Service service : this.services.values()) {
            if (service.calendar == null || startDate != 0 && service.calendar.start_date >= startDate) continue;
            startDate = service.calendar.start_date;
        }
        if (startDate == 0) {
            return null;
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd", Locale.getDefault());
        return LocalDate.parse(String.valueOf(startDate), formatter);
    }

    public LocalDate getCalendarDateStart() {
        LocalDate startDate = null;
        for (Service service : this.services.values()) {
            for (LocalDate date : service.calendar_dates.keySet()) {
                if (startDate != null && !date.isBefore(startDate)) continue;
                startDate = date;
            }
        }
        return startDate;
    }

    public LocalDate getCalendarServiceRangeEnd() {
        int endDate = 0;
        for (Service service : this.services.values()) {
            if (service.calendar == null || endDate != 0 && service.calendar.end_date <= endDate) continue;
            endDate = service.calendar.end_date;
        }
        if (endDate == 0) {
            return null;
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd", Locale.getDefault());
        return LocalDate.parse(String.valueOf(endDate), formatter);
    }

    public LocalDate getEndDate() {
        LocalDate endDate = null;
        if (this.hasFeedInfo()) {
            endDate = this.getFeedInfo().feed_end_date;
        }
        if (endDate == null) {
            endDate = this.getCalendarServiceRangeEnd();
        }
        if (endDate == null) {
            endDate = this.getCalendarDateEnd();
        }
        return endDate;
    }

    public LocalDate getCalendarDateEnd() {
        LocalDate endDate = null;
        for (Service service : this.services.values()) {
            for (LocalDate date : service.calendar_dates.keySet()) {
                if (endDate != null && !date.isAfter(endDate)) continue;
                endDate = date;
            }
        }
        return endDate;
    }

    public class FirstAndLastStopsDoNotHaveTimes
    extends RuntimeException {
    }
}

