/*
 * Decompiled with CFR 0.152.
 */
package com.github.jengelman.gradle.plugins.shadow.relocation;

import com.github.jengelman.gradle.plugins.shadow.relocation.CacheableRelocator;
import com.github.jengelman.gradle.plugins.shadow.relocation.RelocateClassContext;
import com.github.jengelman.gradle.plugins.shadow.relocation.RelocatePathContext;
import com.github.jengelman.gradle.plugins.shadow.relocation.Relocator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.io.FilenameUtils;
import org.codehaus.plexus.util.SelectorUtils;
import org.gradle.api.tasks.Input;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CacheableRelocator
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0017\u0018\u0000 /2\u00020\u0001:\u0001/BY\b\u0007\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0010\b\u0002\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0006\u0012\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J\u0010\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J\u0010\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00032\u0006\u0010!\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u0003H\u0016J\u0013\u0010'\u001a\u00020\t2\b\u0010(\u001a\u0004\u0018\u00010)H\u0096\u0002J\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020\u0003H\u0016J\u0010\u0010-\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u0003H\u0002J\u0010\u0010.\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u0003H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u00020\t8\u0017X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u00148\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0019\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u00148\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017\u00a8\u00060"}, d2={"Lcom/github/jengelman/gradle/plugins/shadow/relocation/SimpleRelocator;", "Lcom/github/jengelman/gradle/plugins/shadow/relocation/Relocator;", "pattern", "", "shadedPattern", "includes", "", "excludes", "rawString", "", "skipStringConstants", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;ZZ)V", "getSkipStringConstants", "()Z", "setSkipStringConstants", "(Z)V", "pathPattern", "shadedPathPattern", "sourcePackageExcludes", "", "sourcePathExcludes", "getIncludes", "()Ljava/util/Set;", "getExcludes", "include", "", "exclude", "canRelocatePath", "path", "canRelocateClass", "className", "relocatePath", "context", "Lcom/github/jengelman/gradle/plugins/shadow/relocation/RelocatePathContext;", "relocateClass", "Lcom/github/jengelman/gradle/plugins/shadow/relocation/RelocateClassContext;", "applyToSourceContent", "sourceContent", "equals", "other", "", "hashCode", "", "toString", "isIncluded", "isExcluded", "Companion", "shadow"})
@SourceDebugExtension(value={"SMAP\nSimpleRelocator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleRelocator.kt\ncom/github/jengelman/gradle/plugins/shadow/relocation/SimpleRelocator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,276:1\n1761#2,3:277\n1761#2,3:280\n*S KotlinDebug\n*F\n+ 1 SimpleRelocator.kt\ncom/github/jengelman/gradle/plugins/shadow/relocation/SimpleRelocator\n*L\n182#1:277,3\n186#1:280,3\n*E\n"})
public class SimpleRelocator
implements Relocator {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private final boolean rawString;
    private boolean skipStringConstants;
    @NotNull
    private final String pattern;
    @NotNull
    private final String pathPattern;
    @NotNull
    private final String shadedPattern;
    @NotNull
    private final String shadedPathPattern;
    @NotNull
    private final Set<String> sourcePackageExcludes;
    @NotNull
    private final Set<String> sourcePathExcludes;
    @NotNull
    private final Set<String> includes;
    @NotNull
    private final Set<String> excludes;
    @NotNull
    private static final Pattern RX_ENDS_WITH_DOT_SLASH_SPACE;
    @NotNull
    private static final Pattern RX_ENDS_WITH_JAVA_KEYWORD;

    @JvmOverloads
    public SimpleRelocator(@Nullable String pattern, @Nullable String shadedPattern, @Nullable List<String> includes, @Nullable List<String> excludes, boolean rawString, boolean skipStringConstants) {
        this.rawString = rawString;
        this.skipStringConstants = skipStringConstants;
        this.sourcePackageExcludes = new LinkedHashSet();
        this.sourcePathExcludes = new LinkedHashSet();
        this.includes = new LinkedHashSet();
        this.excludes = new LinkedHashSet();
        if (this.rawString) {
            String string;
            String string2 = pattern;
            if (string2 == null) {
                string2 = this.pathPattern = "";
            }
            if ((string = shadedPattern) == null) {
                string = "";
            }
            this.shadedPathPattern = string;
            this.pattern = "";
            this.shadedPattern = "";
        } else {
            if (pattern == null) {
                this.pattern = "";
                this.pathPattern = "";
            } else {
                this.pattern = StringsKt.replace$default((String)pattern, (char)'/', (char)'.', (boolean)false, (int)4, null);
                this.pathPattern = StringsKt.replace$default((String)pattern, (char)'.', (char)'/', (boolean)false, (int)4, null);
            }
            if (shadedPattern != null) {
                this.shadedPattern = StringsKt.replace$default((String)shadedPattern, (char)'/', (char)'.', (boolean)false, (int)4, null);
                this.shadedPathPattern = StringsKt.replace$default((String)shadedPattern, (char)'.', (char)'/', (boolean)false, (int)4, null);
            } else {
                this.shadedPattern = "hidden." + this.pattern;
                this.shadedPathPattern = "hidden/" + this.pathPattern;
            }
        }
        this.includes.addAll((Collection<String>)Companion.normalizePatterns((Collection<String>)includes));
        this.excludes.addAll((Collection<String>)Companion.normalizePatterns((Collection<String>)excludes));
        Object object = includes;
        if (!(object == null || object.isEmpty())) {
            this.includes.addAll((Collection<String>)includes);
        }
        if (!((object = (Collection)excludes) == null || object.isEmpty())) {
            this.excludes.addAll((Collection<String>)excludes);
        }
        if (!this.rawString) {
            for (String exclude : this.excludes) {
                String string;
                Regex regex;
                CharSequence charSequence;
                if (StringsKt.startsWith$default((String)exclude, (String)this.pattern, (boolean)false, (int)2, null)) {
                    String string3 = exclude.substring(this.pattern.length());
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    charSequence = string3;
                    regex = new Regex("[.][*]$");
                    string = "";
                    this.sourcePackageExcludes.add(regex.replaceFirst(charSequence, string));
                }
                if (!StringsKt.startsWith$default((String)exclude, (String)this.pathPattern, (boolean)false, (int)2, null)) continue;
                String string4 = exclude.substring(this.pathPattern.length());
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                charSequence = string4;
                regex = new Regex("/[*]$");
                string = "";
                this.sourcePathExcludes.add(regex.replaceFirst(charSequence, string));
            }
        }
    }

    public /* synthetic */ SimpleRelocator(String string, String string2, List list, List list2, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            list = null;
        }
        if ((n & 8) != 0) {
            list2 = null;
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        if ((n & 0x20) != 0) {
            bl2 = false;
        }
        this(string, string2, list, list2, bl, bl2);
    }

    @Override
    @Input
    public boolean getSkipStringConstants() {
        return this.skipStringConstants;
    }

    public void setSkipStringConstants(boolean bl) {
        this.skipStringConstants = bl;
    }

    @Input
    @NotNull
    public final Set<String> getIncludes() {
        return this.includes;
    }

    @Input
    @NotNull
    public final Set<String> getExcludes() {
        return this.excludes;
    }

    public void include(@NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        this.includes.addAll((Collection<String>)Companion.normalizePatterns(CollectionsKt.listOf((Object)pattern)));
    }

    public void exclude(@NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        this.excludes.addAll((Collection<String>)Companion.normalizePatterns(CollectionsKt.listOf((Object)pattern)));
    }

    @Override
    public boolean canRelocatePath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (this.rawString) {
            return Pattern.compile(this.pathPattern).matcher(path).find();
        }
        if (path.length() < this.pathPattern.length()) {
            return false;
        }
        String adjustedPath = StringsKt.removeSuffix((String)path, (CharSequence)".class");
        if (((CharSequence)adjustedPath).length() == 0) {
            return false;
        }
        return this.isIncluded(adjustedPath = StringsKt.removePrefix((String)adjustedPath, (CharSequence)"/")) && !this.isExcluded(adjustedPath) && StringsKt.startsWith$default((String)adjustedPath, (String)this.pathPattern, (boolean)false, (int)2, null);
    }

    @Override
    public boolean canRelocateClass(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        return !this.rawString && !StringsKt.contains$default((CharSequence)className, (char)'/', (boolean)false, (int)2, null) && this.canRelocatePath(StringsKt.replace$default((String)className, (char)'.', (char)'/', (boolean)false, (int)4, null));
    }

    @Override
    @NotNull
    public String relocatePath(@NotNull RelocatePathContext context) {
        String string;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String path = context.getPath();
        if (this.rawString) {
            CharSequence charSequence = path;
            Regex regex = new Regex(this.pathPattern);
            String string2 = this.shadedPathPattern;
            string = regex.replace(charSequence, string2);
        } else {
            CharSequence charSequence = path;
            Regex regex = new Regex(this.pathPattern);
            String string3 = this.shadedPathPattern;
            string = regex.replaceFirst(charSequence, string3);
        }
        return string;
    }

    @Override
    @NotNull
    public String relocateClass(@NotNull RelocateClassContext context) {
        String string;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String clazz = context.getClassName();
        if (this.rawString) {
            string = clazz;
        } else {
            CharSequence charSequence = clazz;
            Regex regex = new Regex(this.pattern);
            String string2 = this.shadedPattern;
            string = regex.replaceFirst(charSequence, string2);
        }
        return string;
    }

    @Override
    @NotNull
    public String applyToSourceContent(@NotNull String sourceContent) {
        Intrinsics.checkNotNullParameter((Object)sourceContent, (String)"sourceContent");
        if (this.rawString) {
            return sourceContent;
        }
        String content = Companion.shadeSourceWithExcludes(sourceContent, this.pattern, this.shadedPattern, this.sourcePackageExcludes);
        return Companion.shadeSourceWithExcludes(content, this.pathPattern, this.shadedPathPattern, this.sourcePathExcludes);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SimpleRelocator)) {
            return false;
        }
        return this.rawString == ((SimpleRelocator)other).rawString && this.getSkipStringConstants() == ((SimpleRelocator)other).getSkipStringConstants() && Intrinsics.areEqual((Object)this.pattern, (Object)((SimpleRelocator)other).pattern) && Intrinsics.areEqual((Object)this.pathPattern, (Object)((SimpleRelocator)other).pathPattern) && Intrinsics.areEqual((Object)this.shadedPattern, (Object)((SimpleRelocator)other).shadedPattern) && Intrinsics.areEqual((Object)this.shadedPathPattern, (Object)((SimpleRelocator)other).shadedPathPattern) && Intrinsics.areEqual(this.sourcePackageExcludes, ((SimpleRelocator)other).sourcePackageExcludes) && Intrinsics.areEqual(this.sourcePathExcludes, ((SimpleRelocator)other).sourcePathExcludes) && Intrinsics.areEqual(this.includes, ((SimpleRelocator)other).includes) && Intrinsics.areEqual(this.excludes, ((SimpleRelocator)other).excludes);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.rawString, this.getSkipStringConstants(), this.pattern, this.pathPattern, this.shadedPattern, this.shadedPathPattern, this.sourcePackageExcludes, this.sourcePathExcludes, this.includes, this.excludes};
        return Objects.hash(objectArray);
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u240.append("SimpleRelocator(");
        $this$toString_u24lambda_u240.append("rawString=" + this.rawString).append(", ");
        $this$toString_u24lambda_u240.append("skipStringConstants=" + this.getSkipStringConstants()).append(", ");
        $this$toString_u24lambda_u240.append("pattern='" + this.pattern + "'").append(", ");
        $this$toString_u24lambda_u240.append("pathPattern='" + this.pathPattern + "'").append(", ");
        $this$toString_u24lambda_u240.append("shadedPattern='" + this.shadedPattern + "'").append(", ");
        $this$toString_u24lambda_u240.append("shadedPathPattern='" + this.shadedPathPattern + "'").append(", ");
        $this$toString_u24lambda_u240.append("sourcePackageExcludes=" + this.sourcePackageExcludes).append(", ");
        $this$toString_u24lambda_u240.append("sourcePathExcludes=" + this.sourcePathExcludes).append(", ");
        $this$toString_u24lambda_u240.append("includes=" + this.includes).append(", ");
        $this$toString_u24lambda_u240.append("excludes=" + this.excludes);
        $this$toString_u24lambda_u240.append(")");
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isIncluded(String path) {
        String it;
        if (this.includes.isEmpty()) return true;
        Iterable $this$any$iv = this.includes;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (String)element$iv;
            boolean bl = false;
        } while (!SelectorUtils.matchPath((String)it, (String)path, (String)"/", (boolean)true));
        return true;
    }

    private final boolean isExcluded(String path) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.excludes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!SelectorUtils.matchPath((String)it, (String)path, (String)"/", (boolean)true)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @JvmOverloads
    public SimpleRelocator(@Nullable String pattern, @Nullable String shadedPattern, @Nullable List<String> includes, @Nullable List<String> excludes, boolean rawString) {
        this(pattern, shadedPattern, includes, excludes, rawString, false, 32, null);
    }

    @JvmOverloads
    public SimpleRelocator(@Nullable String pattern, @Nullable String shadedPattern, @Nullable List<String> includes, @Nullable List<String> excludes) {
        this(pattern, shadedPattern, includes, excludes, false, false, 48, null);
    }

    @JvmOverloads
    public SimpleRelocator(@Nullable String pattern, @Nullable String shadedPattern, @Nullable List<String> includes) {
        this(pattern, shadedPattern, includes, null, false, false, 56, null);
    }

    @JvmOverloads
    public SimpleRelocator(@Nullable String pattern, @Nullable String shadedPattern) {
        this(pattern, shadedPattern, null, null, false, false, 60, null);
    }

    @JvmOverloads
    public SimpleRelocator(@Nullable String pattern) {
        this(pattern, null, null, null, false, false, 62, null);
    }

    @JvmOverloads
    public SimpleRelocator() {
        this(null, null, null, null, false, false, 63, null);
    }

    static {
        Pattern pattern = Pattern.compile("[./ ]$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        RX_ENDS_WITH_DOT_SLASH_SPACE = pattern;
        Pattern pattern2 = Pattern.compile("\\b(import|package|public|protected|private|static|final|synchronized|abstract|volatile|extends|implements|throws) $|\\{@link( \\*)* $|([{}(=;,]|\\*/) $");
        Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"compile(...)");
        RX_ENDS_WITH_JAVA_KEYWORD = pattern2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0006\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000eJ,\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lcom/github/jengelman/gradle/plugins/shadow/relocation/SimpleRelocator$Companion;", "", "<init>", "()V", "RX_ENDS_WITH_DOT_SLASH_SPACE", "Ljava/util/regex/Pattern;", "getRX_ENDS_WITH_DOT_SLASH_SPACE", "()Ljava/util/regex/Pattern;", "RX_ENDS_WITH_JAVA_KEYWORD", "getRX_ENDS_WITH_JAVA_KEYWORD", "normalizePatterns", "", "", "patterns", "", "shadeSourceWithExcludes", "sourceContent", "patternFrom", "patternTo", "excludedPatterns", "shadow"})
    @SourceDebugExtension(value={"SMAP\nSimpleRelocator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleRelocator.kt\ncom/github/jengelman/gradle/plugins/shadow/relocation/SimpleRelocator$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,276:1\n774#2:277\n865#2,2:278\n1878#2,3:280\n*S KotlinDebug\n*F\n+ 1 SimpleRelocator.kt\ncom/github/jengelman/gradle/plugins/shadow/relocation/SimpleRelocator$Companion\n*L\n249#1:277\n249#1:278,2\n250#1:280,3\n*E\n"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Pattern getRX_ENDS_WITH_DOT_SLASH_SPACE() {
            return RX_ENDS_WITH_DOT_SLASH_SPACE;
        }

        @NotNull
        public final Pattern getRX_ENDS_WITH_JAVA_KEYWORD() {
            return RX_ENDS_WITH_JAVA_KEYWORD;
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public final Set<String> normalizePatterns(@Nullable Collection<String> patterns) {
            block4: {
                $this$normalizePatterns_u24lambda_u240 = var2_2 = SetsKt.createSetBuilder();
                $i$a$-buildSet-SimpleRelocator$Companion$normalizePatterns$1 = false;
                if (patterns == null) break block4;
                for (String pattern : patterns) {
                    if (StringsKt.startsWith$default((String)pattern, (String)"%regex[", (boolean)false, (int)2, null)) {
                        $this$normalizePatterns_u24lambda_u240.add(pattern);
                        continue;
                    }
                    fileName = FilenameUtils.getName((String)pattern);
                    fileParent = FilenameUtils.getPathNoEndSeparator((String)pattern);
                    var9_9 = fileParent;
                    if (var9_9 == null || var9_9.length() == 0) ** GOTO lbl-1000
                    Intrinsics.checkNotNull((Object)fileName);
                    if (((CharSequence)fileName).length() > 0) {
                        v0 = pattern;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v0 = StringsKt.replace$default((String)pattern, (char)'.', (char)'/', (boolean)false, (int)4, null);
                    }
                    filePattern = v0;
                    $this$normalizePatterns_u24lambda_u240.add(filePattern);
                    if (!StringsKt.endsWith$default((String)filePattern, (String)"/*", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)filePattern, (String)"/**", (boolean)false, (int)2, null)) continue;
                    packagePattern = StringsKt.take((String)filePattern, (int)StringsKt.lastIndexOf$default((CharSequence)filePattern, (char)'/', (int)0, (boolean)false, (int)6, null));
                    $this$normalizePatterns_u24lambda_u240.add(packagePattern);
                }
            }
            return SetsKt.build((Set)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final String shadeSourceWithExcludes(@NotNull String sourceContent, @NotNull String patternFrom, @NotNull String patternTo, @NotNull Set<String> excludedPatterns) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Intrinsics.checkNotNullParameter((Object)sourceContent, (String)"sourceContent");
            Intrinsics.checkNotNullParameter((Object)patternFrom, (String)"patternFrom");
            Intrinsics.checkNotNullParameter((Object)patternTo, (String)"patternTo");
            Intrinsics.checkNotNullParameter(excludedPatterns, (String)"excludedPatterns");
            StringBuilder shadedSourceContent = new StringBuilder(sourceContent.length() * 11 / 10);
            Object object = sourceContent;
            Regex regex = new Regex("\\b" + StringsKt.replace$default((String)patternFrom, (String)".", (String)"[.]", (boolean)false, (int)4, null) + "\\b");
            int n = 0;
            object = regex.split((CharSequence)object, n);
            boolean $i$f$filter = false;
            void var9_10 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                CharSequence p0 = (CharSequence)element$iv$iv;
                boolean bl = false;
                boolean bl2 = p0.length() > 0;
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List snippets = (List)destination$iv$iv;
            Iterable $this$forEachIndexed$iv = snippets;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                StringBuilder stringBuilder;
                void snippet;
                CharSequence excludedPattern2;
                int n2;
                Object element$iv$iv;
                if ((n2 = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                element$iv$iv = (String)item$iv;
                int i = n2;
                boolean bl = false;
                boolean isFirstSnippet = i == 0;
                String previousSnippet = isFirstSnippet ? "" : (String)snippets.get(i - 1);
                boolean doExclude = false;
                for (CharSequence excludedPattern2 : excludedPatterns) {
                    if (!StringsKt.startsWith$default((String)snippet, (String)excludedPattern2, (boolean)false, (int)2, null)) continue;
                    doExclude = true;
                    break;
                }
                if (isFirstSnippet) {
                    stringBuilder = shadedSourceContent.append((String)snippet);
                    continue;
                }
                excludedPattern2 = previousSnippet;
                Regex regex2 = new Regex("\\s+");
                String string = " ";
                String previousSnippetOneLine = regex2.replace(excludedPattern2, string);
                boolean afterDotSlashSpace = Companion.getRX_ENDS_WITH_DOT_SLASH_SPACE().matcher(previousSnippetOneLine).find();
                boolean afterJavaKeyWord = Companion.getRX_ENDS_WITH_JAVA_KEYWORD().matcher(previousSnippetOneLine).find();
                boolean shouldExclude = doExclude || afterDotSlashSpace && !afterJavaKeyWord;
                stringBuilder = shadedSourceContent.append(shouldExclude ? patternFrom : patternTo).append((String)snippet);
            }
            String string = shadedSourceContent.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

