/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.vafer.jdependency;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import shadow.org.vafer.jdeb.shaded.commons.io.FilenameUtils;
import shadow.org.vafer.jdependency.ClazzpathUnit;

public final class Clazz
implements Comparable<Clazz> {
    private final Set<Clazz> dependencies = new HashSet<Clazz>();
    private final Set<Clazz> references = new HashSet<Clazz>();
    private final Map<ClazzpathUnit, String> units = new HashMap<ClazzpathUnit, String>();
    private final Map<String, ClazzFile> classFilenames = new HashMap<String, ClazzFile>();
    private final String name;
    private static final Pattern EXTRACT_MULTI_RELEASE_JAVA_VERSION = Pattern.compile("^(?:META-INF[\\/\\\\]versions[\\/\\\\](\\d+)[\\/\\\\])?([^.]+).class$");

    public Clazz(String pName) {
        this.name = pName;
    }

    public static ParsedFileName parseClassFileName(String pFileName) {
        if (pFileName == null || !pFileName.endsWith(".class")) {
            return null;
        }
        Matcher matcher = EXTRACT_MULTI_RELEASE_JAVA_VERSION.matcher(pFileName);
        if (!matcher.matches()) {
            return null;
        }
        ParsedFileName result = new ParsedFileName();
        result.forJava = matcher.group(1);
        result.className = FilenameUtils.separatorsToUnix(matcher.group(2)).replace('/', '.');
        if (result.forJava == null || result.forJava.isEmpty()) {
            if (result.className.contains("-")) {
                return null;
            }
            result.forJava = "8";
        }
        return result;
    }

    public static boolean isMultiReleaseClassFile(String pFileName) {
        if (pFileName == null) {
            return false;
        }
        Matcher matcher = EXTRACT_MULTI_RELEASE_JAVA_VERSION.matcher(pFileName);
        if (!matcher.matches()) {
            return false;
        }
        return matcher.group(1) != null && !matcher.group(1).isEmpty();
    }

    public void addMultiReleaseFile(ClazzpathUnit pUnit, String pForJava, String pFileName) {
        this.classFilenames.put(pForJava, new ClazzFile(pUnit, pFileName));
    }

    public String getName() {
        return this.name;
    }

    public Map<String, ClazzFile> getFileNames() {
        return this.classFilenames;
    }

    public void addClazzpathUnit(ClazzpathUnit pUnit, String pDigest) {
        this.units.put(pUnit, pDigest);
    }

    public void removeClazzpathUnit(ClazzpathUnit pUnit) {
        this.units.remove(pUnit);
    }

    public Set<ClazzpathUnit> getClazzpathUnits() {
        return this.units.keySet();
    }

    public Set<String> getVersions() {
        return new HashSet<String>(this.units.values());
    }

    public void addDependency(Clazz pClazz) {
        pClazz.references.add(this);
        this.dependencies.add(pClazz);
    }

    public void removeDependency(Clazz pClazz) {
        pClazz.references.remove(this);
        this.dependencies.remove(pClazz);
    }

    public Set<Clazz> getDependencies() {
        return this.dependencies;
    }

    public Set<Clazz> getReferences() {
        return this.references;
    }

    public Set<Clazz> getTransitiveDependencies() {
        HashSet<Clazz> all = new HashSet<Clazz>();
        this.findTransitiveDependencies(all);
        return all;
    }

    void findTransitiveDependencies(Set<? super Clazz> pAll) {
        for (Clazz clazz : this.dependencies) {
            if (pAll.contains(clazz)) continue;
            pAll.add(clazz);
            clazz.findTransitiveDependencies(pAll);
        }
    }

    public boolean equals(Object pO) {
        if (pO.getClass() != Clazz.class) {
            return false;
        }
        Clazz c = (Clazz)pO;
        return this.name.equals(c.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public int compareTo(Clazz pO) {
        return this.name.compareTo(pO.name);
    }

    public String toString() {
        return this.name + " in " + this.classFilenames;
    }

    public static final class ParsedFileName {
        public String className;
        public String forJava;

        public String toString() {
            return "ParsedFileName{className='" + this.className + '\'' + ", forJava='" + this.forJava + '\'' + '}';
        }
    }

    public static final class ClazzFile {
        private ClazzpathUnit unit;
        private String filename;

        public ClazzFile(ClazzpathUnit unit, String filename) {
            this.unit = unit;
            this.filename = filename;
        }

        public ClazzpathUnit getUnit() {
            return this.unit;
        }

        public String getFilename() {
            return this.filename;
        }

        public String toString() {
            return "ClazzFile{unit=" + this.unit + ", filename='" + this.filename + '\'' + '}';
        }
    }
}

