/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.publish;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Version
implements Comparable<Version> {
    private static final Pattern VERSION_PATTERN = Pattern.compile("((\\d+)(\\.\\d+)+)(-(\\p{Alpha}+)-(\\w+))?(-(SNAPSHOT|\\d{14}([-+]\\d{4})?))?");
    private static final int STAGE_MILESTONE = 0;
    private static final int STAGE_UNKNOWN = 1;
    private static final int STAGE_PREVIEW = 2;
    private static final int STAGE_RC = 3;
    private final String stringForm;
    private final String numericPart;
    private final Stage stage;
    private final Long snapshot;

    public Version(String stringForm) {
        this.stringForm = stringForm;
        Matcher matcher = VERSION_PATTERN.matcher(stringForm);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("'%s' is not a valid version string (examples: '1.0', '1.0-rc-1')", stringForm));
        }
        this.numericPart = matcher.group(1);
        this.stage = this.parseStage(matcher);
        this.snapshot = this.parseSnapshot(matcher);
    }

    public boolean atLeast(Version version) {
        return this.compareTo(version) >= 0;
    }

    @Override
    public int compareTo(Version other) {
        Long theirSnapshot;
        int diff;
        String[] numericParts = this.numericPart.split("\\.");
        String[] otherNumericParts = other.numericPart.split("\\.");
        for (int i = 0; i < numericParts.length && i < otherNumericParts.length; ++i) {
            int otherPart;
            int part = Integer.parseInt(numericParts[i]);
            if (part > (otherPart = Integer.parseInt(otherNumericParts[i]))) {
                return 1;
            }
            if (otherPart <= part) continue;
            return -1;
        }
        if (numericParts.length > otherNumericParts.length) {
            return 1;
        }
        if (numericParts.length < otherNumericParts.length) {
            return -1;
        }
        if (this.stage != null && other.stage != null && (diff = this.stage.compareTo(other.stage)) != 0) {
            return diff;
        }
        if (this.stage == null && other.stage != null) {
            return 1;
        }
        if (this.stage != null && other.stage == null) {
            return -1;
        }
        Long thisSnapshot = this.snapshot == null ? Long.MAX_VALUE : this.snapshot;
        if (thisSnapshot.equals(theirSnapshot = Long.valueOf(other.snapshot == null ? Long.MAX_VALUE : other.snapshot))) {
            return this.stringForm.compareTo(other.stringForm);
        }
        return thisSnapshot.compareTo(theirSnapshot);
    }

    private Long parseSnapshot(Matcher matcher) {
        if ("snapshot".equals(matcher.group(5)) || this.isCommitVersion(matcher)) {
            return 0L;
        }
        if (matcher.group(8) == null) {
            return null;
        }
        if ("SNAPSHOT".equals(matcher.group(8))) {
            return 0L;
        }
        try {
            if (matcher.group(9) != null) {
                return new SimpleDateFormat("yyyyMMddHHmmssZ").parse(matcher.group(8)).getTime();
            }
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
            format.setTimeZone(TimeZone.getTimeZone("UTC"));
            return format.parse(matcher.group(8)).getTime();
        }
        catch (ParseException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private Stage parseStage(Matcher matcher) {
        if (matcher.group(4) == null || this.isCommitVersion(matcher)) {
            return null;
        }
        if (this.isStage("milestone", matcher)) {
            return Stage.from(0, matcher.group(6));
        }
        if (this.isStage("preview", matcher)) {
            return Stage.from(2, matcher.group(6));
        }
        if (this.isStage("rc", matcher)) {
            return Stage.from(3, matcher.group(6));
        }
        return Stage.from(1, matcher.group(6));
    }

    private boolean isCommitVersion(Matcher matcher) {
        return "commit".equals(matcher.group(5));
    }

    private boolean isStage(String stage, Matcher matcher) {
        return stage.equals(matcher.group(5));
    }

    public String toString() {
        return this.stringForm;
    }

    static final class Stage
    implements Comparable<Stage> {
        final int stage;
        final int number;
        final Character patchNo;

        private Stage(int stage, int number, Character patchNo) {
            this.stage = stage;
            this.number = number;
            this.patchNo = patchNo;
        }

        static Stage from(int stage, String stageString) {
            Matcher m = Pattern.compile("(\\d+)([a-z])?").matcher(stageString);
            if (!m.matches()) {
                return null;
            }
            int number = Integer.parseInt(m.group(1));
            if (m.groupCount() == 2 && m.group(2) != null) {
                return new Stage(stage, number, Character.valueOf(m.group(2).charAt(0)));
            }
            return new Stage(stage, number, Character.valueOf('_'));
        }

        @Override
        public int compareTo(Stage other) {
            if (this.stage > other.stage) {
                return 1;
            }
            if (this.stage < other.stage) {
                return -1;
            }
            if (this.number > other.number) {
                return 1;
            }
            if (this.number < other.number) {
                return -1;
            }
            if (this.patchNo.charValue() > other.patchNo.charValue()) {
                return 1;
            }
            if (this.patchNo.charValue() < other.patchNo.charValue()) {
                return -1;
            }
            return 0;
        }
    }
}

