package com.gradle.publish;

import com.gradle.protocols.ServerResponseBase;

final class ResponseUtil {

    private ResponseUtil() {
    }

    public static <T extends ServerResponseBase> void assertValidResponse(String actionMsg, T apiResponse) {
        String errorMessage = "";
        if (apiResponse == null) {
            errorMessage += "Did not get a response from server";
            throw new RuntimeException(actionMsg + "\n" + errorMessage);
        } else if (apiResponse.hasFailed() && apiResponse.getErrorMessage() != null) {
            errorMessage += "Server responded with:\n" + apiResponse.getErrorMessage();
            throw new RuntimeException(actionMsg + "\n" + errorMessage);
        } else if (apiResponse.hasFailed()) {
            errorMessage += "Server did not specify reason";
            throw new RuntimeException(actionMsg + "\n" + errorMessage);
        }
    }
}
