package com.gradle.publish;

import org.gradle.api.artifacts.ModuleDependency;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

final class AugmentedCoordinatesModuleDependency {

    public static ModuleDependency augment(ModuleDependency dependency, MavenCoordinates coordinates) {
        return (ModuleDependency) Proxy.newProxyInstance(
            AugmentedCoordinatesModuleDependency.class.getClassLoader(),
            new Class[] { ModuleDependency.class },
            new Handler(dependency, coordinates)
        );
    }

    private static class Handler implements InvocationHandler {

        private final ModuleDependency dependency;
        private final MavenCoordinates coordinates;

        Handler(ModuleDependency dependency, MavenCoordinates coordinates) {
            this.dependency = dependency;
            this.coordinates = coordinates;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (methodName.equals("getGroup")) {
                return coordinates.getGroup();
            } else if(methodName.equals("getName")) {
                return coordinates.getArtifactId();
            } else if(methodName.equals("getVersion")) {
                return coordinates.getVersion();
            } else if(methodName.equals("copy")) {
                return augment(dependency.copy(), coordinates.copy());
            } else if (method.getDeclaringClass().equals(ModuleDependency.class)) {
                return method.invoke(dependency, args);
            } else if(methodName.equals("equals") && args.length == 1) {
                return proxy == args[0];
            } else if(methodName.equals("toString") && args == null) {
                return super.toString();
            } else if(methodName.equals("hashCode") && args == null) {
                return super.hashCode();
            } else {
                throw new UnsupportedOperationException(methodName);
            }
        }
    }

    private AugmentedCoordinatesModuleDependency() {
    }
}
