/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.publish;

import com.gradle.publish.Hasher;
import com.gradle.publish.PortalPublisher;
import com.gradle.publish.protocols.v1.models.publish.ArtifactTypeCodec;
import com.gradle.publish.protocols.v1.models.publish.BuildMetadata;
import com.gradle.publish.protocols.v1.models.publish.PublishArtifact;
import com.gradle.publish.protocols.v1.models.publish.PublishMavenCoordinates;
import com.gradle.publish.protocols.v1.models.publish.PublishNewVersionRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.notations.ComponentIdentifierParserFactory;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.typeconversion.NotationParser;

public abstract class PublishExistingTask
extends DefaultTask {
    private static final Logger LOGGER = Logging.getLogger(PublishExistingTask.class);
    private final PortalPublisher portalPublisher = new PortalPublisher(this.getProject());

    @InputDirectory
    public abstract DirectoryProperty getFileRepositoryRoot();

    @Input
    public abstract Property<String> getPluginId();

    @Input
    public abstract Property<String> getPluginDescription();

    @Input
    public abstract Property<String> getDisplayName();

    @Input
    public abstract Property<String> getPluginVersion();

    @Input
    public abstract Property<String> getWebsite();

    @Input
    public abstract Property<String> getVcsUrl();

    @Input
    public abstract ListProperty<String> getTags();

    @Input
    public abstract Property<String> getPluginCoordinates();

    @TaskAction
    void publish() throws Exception {
        List<PublishNewVersionRequest> requests = this.buildPublishRequests();
        ComponentIdentifierParserFactory componentIdentifierParserFactory = new ComponentIdentifierParserFactory();
        NotationParser notationParser = componentIdentifierParserFactory.create();
        ModuleComponentIdentifier componentIdentifier = (ModuleComponentIdentifier)this.getPluginCoordinates().map(arg_0 -> ((NotationParser)notationParser).parseNotation(arg_0)).get();
        Provider repoEntry = this.getFileRepositoryRoot().dir(componentIdentifier.getGroup().replace('.', '/') + "/" + componentIdentifier.getModule() + "/" + componentIdentifier.getVersion());
        Map<PublishArtifact, File> artifacts = this.collectArtifacts(componentIdentifier, (Directory)repoEntry.get());
        this.validateArtifacts(artifacts, (Provider<Directory>)repoEntry);
        this.portalPublisher.publishToPortal(requests, new PublishMavenCoordinates(componentIdentifier.getGroup(), componentIdentifier.getModule(), componentIdentifier.getVersion()), artifacts);
    }

    private void validateArtifacts(Map<PublishArtifact, File> artifacts, Provider<Directory> repoEntry) {
        if (artifacts.isEmpty()) {
            throw new IllegalStateException("Could not find any artifacts to publish in '" + ((Directory)repoEntry.get()).getAsFile() + "'");
        }
        boolean hasJar = false;
        boolean hasMetadata = false;
        for (PublishArtifact publishArtifact : artifacts.keySet()) {
            if (publishArtifact.getType().equals("jar")) {
                hasJar = true;
                continue;
            }
            if (!publishArtifact.getType().equals("pom")) continue;
            hasMetadata = true;
        }
        if (!hasJar) {
            throw new IllegalStateException("Could not find a main jar artifact to publish in '" + ((Directory)repoEntry.get()).getAsFile() + "'");
        }
        if (!hasMetadata) {
            throw new IllegalStateException("Could not find a maven pom to publish in '" + ((Directory)repoEntry.get()).getAsFile() + "'");
        }
    }

    void addAndHashArtifact(Map<PublishArtifact, File> artifacts, File file, String filePrefix) throws IOException {
        String extension;
        String fileName = file.getName();
        String classifierAndExtension = fileName.replace(filePrefix, "");
        int extensionSeparator = classifierAndExtension.indexOf(46);
        String classifier = null;
        if (extensionSeparator > 0) {
            classifier = classifierAndExtension.substring(1, extensionSeparator);
        }
        if ((extension = classifierAndExtension.substring(extensionSeparator + 1)).contains("md5") || extension.contains("sha")) {
            return;
        }
        try (FileInputStream fis = new FileInputStream(file);){
            String hash = Hasher.hash(fis);
            try {
                String artifactType = ArtifactTypeCodec.encode(extension, classifier);
                artifacts.put(new PublishArtifact(artifactType, hash), file);
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("Ignoring unknown artifact with type \"{}\" and classifier \"{}\".\nYou can only upload normal jars, sources jars, javadoc jars and groovydoc jars\nwith or without signatures to the Plugin Portal at this time.", (Object)extension, (Object)classifier);
            }
        }
    }

    private Map<PublishArtifact, File> collectArtifacts(ModuleComponentIdentifier identifier, Directory repoEntry) throws IOException {
        String filePrefix = identifier.getModule() + "-" + identifier.getVersion();
        LinkedHashMap<PublishArtifact, File> artifacts = new LinkedHashMap<PublishArtifact, File>();
        for (File file : repoEntry.getAsFileTree().getFiles()) {
            this.addAndHashArtifact(artifacts, file, filePrefix);
        }
        return artifacts;
    }

    private List<PublishNewVersionRequest> buildPublishRequests() {
        ArrayList<PublishNewVersionRequest> reqs = new ArrayList<PublishNewVersionRequest>();
        reqs.add(this.buildPublishRequest());
        return reqs;
    }

    private PublishNewVersionRequest buildPublishRequest() {
        PublishNewVersionRequest request = new PublishNewVersionRequest();
        BuildMetadata buildMetadata = new BuildMetadata(this.getProject().getGradle().getGradleVersion());
        request.setBuildMetadata(buildMetadata);
        request.setPluginId((String)this.getPluginId().get());
        String pluginVersion = (String)this.getPluginVersion().getOrElse((Object)this.getProject().getVersion().toString());
        request.setPluginVersion(pluginVersion);
        request.setDisplayName((String)this.getDisplayName().get());
        request.setDescription((String)this.getPluginDescription().get());
        request.setTags((List)this.getTags().get());
        request.setWebSite((String)this.getWebsite().get());
        request.setVcsUrl((String)this.getVcsUrl().get());
        return request;
    }
}

