/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.receipts.protocols.v1.models.fragments;

import com.gradle.protocols.util.Hasher;
import com.gradle.receipts.protocols.v1.models.Hashable;
import com.gradle.receipts.protocols.v1.models.ReceiptFragment;
import com.gradle.receipts.protocols.v1.models.ReceiptFragmentType;
import java.util.List;

public class ProjectFragment
extends ReceiptFragment {
    private final String path;
    private final String name;
    private final String projectHash;
    private final String buildScriptFilename;
    private final String buildScriptHash;
    private final List<Repository> repositories;

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    public String getBuildScriptFilename() {
        return this.buildScriptFilename;
    }

    public String getBuildScriptHash() {
        return this.buildScriptHash;
    }

    public List<Repository> getRepositories() {
        return this.repositories;
    }

    public String getProjectHash() {
        return this.projectHash;
    }

    public ProjectFragment(String path, String name, String projectHash, String buildScriptFilename, String buildScriptHash, List<Repository> repositories) {
        super(ReceiptFragmentType.PROJECT, Hasher.hashMultiple(path, name, projectHash, buildScriptFilename, buildScriptHash, ProjectFragment.hashRepositories(repositories)));
        this.path = path;
        this.name = name;
        this.projectHash = projectHash;
        this.buildScriptFilename = buildScriptFilename;
        this.buildScriptHash = buildScriptHash;
        this.repositories = repositories;
    }

    private static String hashRepositories(List<Repository> repositories) {
        String hash = "";
        for (Repository repository : repositories) {
            hash = Hasher.hashMultiple(hash, repository.getHash());
        }
        return hash;
    }

    public static class Repository
    implements Hashable {
        private final String name;
        private final String url;
        private final List<String> artifactUrls;
        private final String repositoryTypeClassName;

        public Repository(String name, String url, List<String> artifactUrls, String repositoryTypeClassName) {
            this.name = name;
            this.url = url;
            this.artifactUrls = artifactUrls;
            this.repositoryTypeClassName = repositoryTypeClassName;
        }

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.url;
        }

        public List<String> getArtifactUrls() {
            return this.artifactUrls;
        }

        public String getRepositoryTypeClassName() {
            return this.repositoryTypeClassName;
        }

        @Override
        public String getHash() {
            return Hasher.hashMultiple(this.name, this.url, Hasher.hashMultiple(this.artifactUrls), this.repositoryTypeClassName);
        }
    }
}

