/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.receipts.protocols.v1.models;

import com.gradle.protocols.JsonService;
import com.gradle.receipts.protocols.v1.models.ReceiptFragmentIdentifiable;
import com.gradle.receipts.protocols.v1.models.ReceiptFragmentType;
import com.gradle.receipts.protocols.v1.models.fragments.BuildResultFragment;
import com.gradle.receipts.protocols.v1.models.fragments.DependenciesFragment;
import com.gradle.receipts.protocols.v1.models.fragments.ProjectFragment;
import com.gradle.receipts.protocols.v1.models.fragments.SystemFragment;
import com.gradle.receipts.protocols.v1.models.fragments.VcsFragment;
import com.gradle.receipts.protocols.v1.models.fragments.metrics.BuildCompletedFragment;
import com.gradle.receipts.protocols.v1.models.fragments.metrics.ProjectCompletedFragment;
import com.gradle.receipts.protocols.v1.models.fragments.metrics.ProjectStartedFragment;
import com.gradle.receipts.protocols.v1.models.fragments.metrics.TaskCompletedFragment;
import com.gradle.receipts.protocols.v1.models.fragments.metrics.TaskStartedFragment;
import java.io.Serializable;

public abstract class ReceiptFragment
implements Serializable,
ReceiptFragmentIdentifiable {
    private final String apiVersion = "1";
    private final String type;
    private final String hash;
    private transient String cachedJson;

    protected ReceiptFragment(ReceiptFragmentType type, String hash) {
        this.type = type.getId();
        this.hash = hash;
    }

    public String getApiVersion() {
        return "1";
    }

    public static <T extends ReceiptFragment> Class<T> getClass(ReceiptFragmentType type) {
        Class clazz;
        switch (type) {
            case PROJECT_STARTED: {
                clazz = ProjectStartedFragment.class;
                break;
            }
            case PROJECT_COMPLETED: {
                clazz = ProjectCompletedFragment.class;
                break;
            }
            case PROJECT: {
                clazz = ProjectFragment.class;
                break;
            }
            case BUILD_RESULT: {
                clazz = BuildResultFragment.class;
                break;
            }
            case BUILD_COMPLETED: {
                clazz = BuildCompletedFragment.class;
                break;
            }
            case DEPENDENCIES: {
                clazz = DependenciesFragment.class;
                break;
            }
            case SYSTEM: {
                clazz = SystemFragment.class;
                break;
            }
            case TASK_STARTED: {
                clazz = TaskStartedFragment.class;
                break;
            }
            case TASK_COMPLETED: {
                clazz = TaskCompletedFragment.class;
                break;
            }
            case VCS: {
                clazz = VcsFragment.class;
                break;
            }
            default: {
                throw new RuntimeException("Cannot find fragment class for unknown type: " + (Object)((Object)type));
            }
        }
        return clazz;
    }

    @Override
    public ReceiptFragmentType getType() {
        return ReceiptFragmentType.valueOf(this.type.toUpperCase());
    }

    @Override
    public String getFragmentHash() {
        return this.hash;
    }

    public final String getJson() {
        if (this.cachedJson == null) {
            this.cachedJson = JsonService.convertToString(this);
        }
        return this.cachedJson;
    }
}

