/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.publish;

import com.gradle.publish.protocols.v1.models.publish.PublishMavenCoordinates;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.project.MavenProject;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.ModuleDependency;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PomWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PomWriter.class);
    private final ConfigurationContainer configurations;

    public PomWriter(ConfigurationContainer configurations) {
        this.configurations = configurations;
    }

    public MavenProject makeMavenProject(PublishMavenCoordinates coords) {
        Configuration compile = this.configurations.getByName("compile");
        Configuration runtime = this.configurations.getByName("runtime");
        return this.makeMavenProject(coords.getGroupId(), coords.getArtifactId(), coords.getVersion(), compile, runtime);
    }

    public MavenProject makeMavenProject(String groupId, String artifactId, String version, Configuration compile, Configuration runtime) {
        MavenProject mavenProject = new MavenProject();
        mavenProject.setGroupId(groupId);
        mavenProject.setArtifactId(artifactId);
        mavenProject.setVersion(version);
        mavenProject.setDependencies(this.getDependencies(compile, runtime));
        return mavenProject;
    }

    private List<Dependency> getDependencies(Configuration compile, Configuration runtime) {
        ArrayList<Dependency> mavenDeps = new ArrayList<Dependency>();
        this.addDependencies(mavenDeps, compile, "compile");
        this.addDependencies(mavenDeps, runtime, "runtime");
        return mavenDeps;
    }

    private void addDependencies(List<Dependency> mavenDeps, Configuration config, String scope) {
        for (org.gradle.api.artifacts.Dependency dep : config.getDependencies()) {
            if (!(dep instanceof ModuleDependency)) continue;
            this.addDependency(mavenDeps, (ModuleDependency)dep, scope);
        }
    }

    private void addDependency(List<Dependency> mavenDeps, ModuleDependency dep, String scope) {
        Set excludeRules;
        Dependency mavenDep = new Dependency();
        mavenDep.setGroupId(dep.getGroup());
        mavenDep.setArtifactId(dep.getName());
        mavenDep.setVersion(dep.getVersion());
        mavenDep.setScope(scope);
        if (!dep.isTransitive()) {
            LOGGER.warn(String.format("Dependency %s:%s:%s is marked as non-transitive, but this is notsupported by the underlying Maven publishing mechanism", dep.getGroup(), dep.getName(), dep.getVersion()));
        }
        if ((excludeRules = dep.getExcludeRules()) != null) {
            for (ExcludeRule e : excludeRules) {
                Exclusion mavenEx = new Exclusion();
                mavenEx.setGroupId(e.getGroup());
                mavenEx.setArtifactId(e.getModule());
                mavenDep.addExclusion(mavenEx);
            }
        }
        mavenDeps.add(mavenDep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePom(File target, MavenProject mavenProject) throws IOException {
        target.getParentFile().mkdirs();
        FileWriter writer = null;
        try {
            writer = new FileWriter(target);
            mavenProject.writeModel((Writer)writer);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }
}

