/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.publish.protocols.v1.models.publish;

public enum ArtifactType {
    JAR("jar", ""),
    POM("pom", ""),
    SIGNATURE_JAR("jar.asc", ""),
    SIGNATURE_POM("pom.asc", ""),
    SIGNATURE_SOURCES("jar.asc", "sources"),
    SIGNATURE_JAVADOC("jar.asc", "javadoc"),
    SIGNATURE_GROOVYDOC("jar.asc", "groovydoc"),
    SOURCES("jar", "sources"),
    JAVADOC("jar", "javadoc"),
    GROOVYDOC("jar", "groovydoc");

    private final String classifier;
    private final String type;

    private ArtifactType(String type, String classifier) {
        this.classifier = classifier;
        this.type = type;
    }

    public static ArtifactType find(String type, String classifier) {
        if (classifier == null) {
            classifier = "";
        }
        for (ArtifactType artifactType : ArtifactType.values()) {
            if (!artifactType.type.equals(type) || !artifactType.classifier.equals(classifier)) continue;
            return artifactType;
        }
        return null;
    }

    public String getType() {
        return this.type;
    }

    public String getClassifier() {
        return this.classifier.isEmpty() ? null : this.classifier;
    }
}

