/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.apache.http.client.protocol;

import com.gradle.scan.plugin.internal.dep.org.apache.commons.logging.Log;
import com.gradle.scan.plugin.internal.dep.org.apache.commons.logging.LogFactory;
import com.gradle.scan.plugin.internal.dep.org.apache.http.HttpException;
import com.gradle.scan.plugin.internal.dep.org.apache.http.HttpRequest;
import com.gradle.scan.plugin.internal.dep.org.apache.http.HttpRequestInterceptor;
import com.gradle.scan.plugin.internal.dep.org.apache.http.client.protocol.HttpClientContext;
import com.gradle.scan.plugin.internal.dep.org.apache.http.conn.routing.RouteInfo;
import com.gradle.scan.plugin.internal.dep.org.apache.http.protocol.HttpContext;
import com.gradle.scan.plugin.internal.dep.org.apache.http.util.Args;
import java.io.IOException;

public class RequestClientConnControl
implements HttpRequestInterceptor {
    private final Log log = LogFactory.getLog(this.getClass());

    @Override
    public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
        Args.notNull(httpRequest, "HTTP request");
        String string = httpRequest.getRequestLine().getMethod();
        if (string.equalsIgnoreCase("CONNECT")) {
            httpRequest.setHeader("Proxy-Connection", "Keep-Alive");
            return;
        }
        HttpClientContext httpClientContext = HttpClientContext.adapt(httpContext);
        RouteInfo routeInfo = httpClientContext.getHttpRoute();
        if (routeInfo == null) {
            this.log.debug("Connection route not set in the context");
            return;
        }
        if ((routeInfo.getHopCount() == 1 || routeInfo.isTunnelled()) && !httpRequest.containsHeader("Connection")) {
            httpRequest.addHeader("Connection", "Keep-Alive");
        }
        if (routeInfo.getHopCount() == 2 && !routeInfo.isTunnelled() && !httpRequest.containsHeader("Proxy-Connection")) {
            httpRequest.addHeader("Proxy-Connection", "Keep-Alive");
        }
    }
}

