/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.apache.http;

import com.gradle.scan.plugin.internal.dep.org.apache.http.util.Args;
import com.gradle.scan.plugin.internal.dep.org.apache.http.util.LangUtils;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Locale;

public final class HttpHost
implements Serializable,
Cloneable {
    protected final String hostname;
    protected final String lcHostname;
    protected final int port;
    protected final String schemeName;
    protected final InetAddress address;

    public HttpHost(String string, int n2, String string2) {
        this.hostname = Args.containsNoBlanks(string, "Host name");
        this.lcHostname = string.toLowerCase(Locale.ROOT);
        this.schemeName = string2 != null ? string2.toLowerCase(Locale.ROOT) : "http";
        this.port = n2;
        this.address = null;
    }

    public HttpHost(String string, int n2) {
        this(string, n2, null);
    }

    public HttpHost(InetAddress inetAddress, int n2, String string) {
        this(Args.notNull(inetAddress, "Inet address"), inetAddress.getHostName(), n2, string);
    }

    public HttpHost(InetAddress inetAddress, String string, int n2, String string2) {
        this.address = Args.notNull(inetAddress, "Inet address");
        this.hostname = Args.notNull(string, "Hostname");
        this.lcHostname = this.hostname.toLowerCase(Locale.ROOT);
        this.schemeName = string2 != null ? string2.toLowerCase(Locale.ROOT) : "http";
        this.port = n2;
    }

    public String getHostName() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getSchemeName() {
        return this.schemeName;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public String toURI() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.schemeName);
        stringBuilder.append("://");
        stringBuilder.append(this.hostname);
        if (this.port != -1) {
            stringBuilder.append(':');
            stringBuilder.append(Integer.toString(this.port));
        }
        return stringBuilder.toString();
    }

    public String toHostString() {
        if (this.port != -1) {
            StringBuilder stringBuilder = new StringBuilder(this.hostname.length() + 6);
            stringBuilder.append(this.hostname);
            stringBuilder.append(":");
            stringBuilder.append(Integer.toString(this.port));
            return stringBuilder.toString();
        }
        return this.hostname;
    }

    public String toString() {
        return this.toURI();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof HttpHost) {
            HttpHost httpHost = (HttpHost)object;
            return this.lcHostname.equals(httpHost.lcHostname) && this.port == httpHost.port && this.schemeName.equals(httpHost.schemeName) && (this.address == null ? httpHost.address == null : this.address.equals(httpHost.address));
        }
        return false;
    }

    public int hashCode() {
        int n2 = 17;
        n2 = LangUtils.hashCode(n2, this.lcHostname);
        n2 = LangUtils.hashCode(n2, this.port);
        n2 = LangUtils.hashCode(n2, this.schemeName);
        if (this.address != null) {
            n2 = LangUtils.hashCode(n2, this.address);
        }
        return n2;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

