/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.apache.commons.lang3;

import com.gradle.scan.plugin.internal.dep.org.apache.commons.lang3.CharSequenceUtils;
import com.gradle.scan.plugin.internal.dep.org.apache.commons.lang3.StringUtils;

public abstract class Strings {
    public static final Strings CI = new CiStrings(true);
    public static final Strings CS = new CsStrings(true);
    private final boolean ignoreCase;
    private final boolean nullIsLess;

    private Strings(boolean bl2, boolean bl3) {
        this.ignoreCase = bl2;
        this.nullIsLess = bl3;
    }

    public abstract boolean contains(CharSequence var1, CharSequence var2);

    public String removeStart(String string, CharSequence charSequence) {
        if (string != null && this.startsWith(string, charSequence)) {
            return string.substring(StringUtils.length(charSequence));
        }
        return string;
    }

    public boolean startsWith(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence == null || charSequence2 == null) {
            return charSequence == charSequence2;
        }
        int n2 = charSequence2.length();
        if (n2 > charSequence.length()) {
            return false;
        }
        return CharSequenceUtils.regionMatches(charSequence, this.ignoreCase, 0, charSequence2, 0, n2);
    }

    private static final class CiStrings
    extends Strings {
        private CiStrings(boolean bl2) {
            super(true, bl2);
        }

        @Override
        public boolean contains(CharSequence charSequence, CharSequence charSequence2) {
            if (charSequence == null || charSequence2 == null) {
                return false;
            }
            int n2 = charSequence2.length();
            int n3 = charSequence.length() - n2;
            for (int i2 = 0; i2 <= n3; ++i2) {
                if (!CharSequenceUtils.regionMatches(charSequence, true, i2, charSequence2, 0, n2)) continue;
                return true;
            }
            return false;
        }
    }

    private static final class CsStrings
    extends Strings {
        private CsStrings(boolean bl2) {
            super(false, bl2);
        }

        @Override
        public boolean contains(CharSequence charSequence, CharSequence charSequence2) {
            return CharSequenceUtils.indexOf(charSequence, charSequence2, 0) >= 0;
        }
    }
}

