/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.util;

import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.ThrowableUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.security.AccessController;
import java.security.Provider;
import java.security.Security;
import javax.net.ssl.SSLEngine;

public final class BouncyCastleUtil {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(BouncyCastleUtil.class);
    private static volatile Throwable unavailabilityCauseBcProv;
    private static volatile Throwable unavailabilityCauseBcPkix;
    private static volatile Throwable unavailabilityCauseBcTls;
    private static volatile Provider bcProviderJce;
    private static volatile Provider bcProviderJsse;
    private static volatile Class<? extends SSLEngine> bcSSLEngineClass;
    private static volatile boolean attemptedLoading;

    public static boolean isBcPkixAvailable() {
        BouncyCastleUtil.ensureLoaded();
        return unavailabilityCauseBcPkix == null;
    }

    public static boolean isBcTlsAvailable() {
        BouncyCastleUtil.ensureLoaded();
        return unavailabilityCauseBcTls == null;
    }

    public static Throwable unavailabilityCauseBcPkix() {
        BouncyCastleUtil.ensureLoaded();
        return unavailabilityCauseBcPkix;
    }

    public static Throwable unavailabilityCauseBcTls() {
        BouncyCastleUtil.ensureLoaded();
        return unavailabilityCauseBcTls;
    }

    public static boolean isBcJsseInUse(SSLEngine sSLEngine) {
        BouncyCastleUtil.ensureLoaded();
        Class<? extends SSLEngine> clazz = bcSSLEngineClass;
        return clazz != null && clazz.isInstance(sSLEngine);
    }

    public static Provider getBcProviderJce() {
        BouncyCastleUtil.ensureLoaded();
        Throwable throwable = unavailabilityCauseBcProv;
        Provider provider = bcProviderJce;
        if (throwable != null || provider == null) {
            throw new IllegalStateException(throwable);
        }
        return provider;
    }

    public static Provider getBcProviderJsse() {
        BouncyCastleUtil.ensureLoaded();
        Throwable throwable = unavailabilityCauseBcTls;
        Provider provider = bcProviderJsse;
        if (throwable != null || provider == null) {
            throw new IllegalStateException(throwable);
        }
        return provider;
    }

    private static void ensureLoaded() {
        if (!attemptedLoading) {
            BouncyCastleUtil.tryLoading();
        }
    }

    private static void tryLoading() {
        AccessController.doPrivileged(() -> {
            Class<?> clazz;
            Object object;
            Object object2;
            try {
                object2 = Security.getProvider("BC");
                if (object2 == null) {
                    object2 = Security.getProvider("BCFIPS");
                }
                if (object2 == null) {
                    object = BouncyCastleUtil.class.getClassLoader();
                    try {
                        clazz = Class.forName("org.bouncycastle.jce.provider.BouncyCastleProvider", true, (ClassLoader)object);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        try {
                            clazz = Class.forName("org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider", true, (ClassLoader)object);
                        }
                        catch (ClassNotFoundException classNotFoundException2) {
                            ThrowableUtil.addSuppressed((Throwable)classNotFoundException, classNotFoundException2);
                            throw classNotFoundException;
                        }
                    }
                    object2 = (Provider)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                bcProviderJce = object2;
                logger.debug("Bouncy Castle provider available");
            }
            catch (Throwable throwable) {
                logger.debug("Cannot load Bouncy Castle provider", throwable);
                unavailabilityCauseBcProv = throwable;
            }
            try {
                object2 = BouncyCastleUtil.class.getClassLoader();
                object = bcProviderJce;
                if (object != null) {
                    object2 = object.getClass().getClassLoader();
                }
                Class.forName("org.bouncycastle.openssl.PEMParser", true, (ClassLoader)object2);
                logger.debug("Bouncy Castle PKIX available");
            }
            catch (Throwable throwable) {
                logger.debug("Cannot load Bouncy Castle PKIX", throwable);
                unavailabilityCauseBcPkix = throwable;
            }
            try {
                object2 = BouncyCastleUtil.class.getClassLoader();
                object = Security.getProvider("BCJSSE");
                if (object != null) {
                    object2 = object.getClass().getClassLoader();
                } else {
                    clazz = Class.forName("org.bouncycastle.jsse.provider.BouncyCastleJsseProvider", true, (ClassLoader)object2);
                    object = (Provider)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                bcSSLEngineClass = Class.forName("org.bouncycastle.jsse.BCSSLEngine", true, (ClassLoader)object2);
                Class.forName("org.bouncycastle.jsse.BCApplicationProtocolSelector", true, (ClassLoader)object2);
                bcProviderJsse = object;
                logger.debug("Bouncy Castle JSSE available");
            }
            catch (Throwable throwable) {
                logger.debug("Cannot load Bouncy Castle TLS", throwable);
                unavailabilityCauseBcTls = throwable;
            }
            attemptedLoading = true;
            return null;
        });
    }

    private BouncyCastleUtil() {
    }
}

