/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl;

import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBufAllocator;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.ApplicationProtocolConfig;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.CipherSuiteFilter;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.ClientAuth;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.OpenSsl;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.OpenSslApplicationProtocolNegotiator;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.OpenSslCachingX509KeyManagerFactory;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.OpenSslKeyMaterialManager;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.OpenSslKeyMaterialProvider;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.OpenSslServerSessionContext;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.OpenSslSessionTicketKey;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.OpenSslX509KeyManagerFactory;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.ResumptionController;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.SslContextOption;
import com.gradle.scan.plugin.internal.dep.io.netty.internal.tcnative.CertificateCallback;
import com.gradle.scan.plugin.internal.dep.io.netty.internal.tcnative.CertificateVerifier;
import com.gradle.scan.plugin.internal.dep.io.netty.internal.tcnative.SSL;
import com.gradle.scan.plugin.internal.dep.io.netty.internal.tcnative.SSLContext;
import com.gradle.scan.plugin.internal.dep.io.netty.internal.tcnative.SniHostNameMatcher;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;

public final class ReferenceCountedOpenSslServerContext
extends ReferenceCountedOpenSslContext {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ReferenceCountedOpenSslServerContext.class);
    private static final byte[] ID = new byte[]{110, 101, 116, 116, 121};
    private final OpenSslServerSessionContext sessionContext;

    ReferenceCountedOpenSslServerContext(X509Certificate[] x509CertificateArray, TrustManagerFactory trustManagerFactory, X509Certificate[] x509CertificateArray2, PrivateKey privateKey, String string, KeyManagerFactory keyManagerFactory, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, long l2, long l3, ClientAuth clientAuth, String[] stringArray, boolean bl2, boolean bl3, String string2, ResumptionController resumptionController, Map.Entry<SslContextOption<?>, Object> ... entryArray) throws SSLException {
        this(x509CertificateArray, trustManagerFactory, x509CertificateArray2, privateKey, string, keyManagerFactory, iterable, cipherSuiteFilter, ReferenceCountedOpenSslServerContext.toNegotiator(applicationProtocolConfig), l2, l3, clientAuth, stringArray, bl2, bl3, string2, resumptionController, entryArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReferenceCountedOpenSslServerContext(X509Certificate[] x509CertificateArray, TrustManagerFactory trustManagerFactory, X509Certificate[] x509CertificateArray2, PrivateKey privateKey, String string, KeyManagerFactory keyManagerFactory, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, OpenSslApplicationProtocolNegotiator openSslApplicationProtocolNegotiator, long l2, long l3, ClientAuth clientAuth, String[] stringArray, boolean bl2, boolean bl3, String string2, ResumptionController resumptionController, Map.Entry<SslContextOption<?>, Object> ... entryArray) throws SSLException {
        super(iterable, cipherSuiteFilter, openSslApplicationProtocolNegotiator, 1, x509CertificateArray2, clientAuth, stringArray, bl2, null, bl3, true, null, resumptionController, entryArray);
        boolean bl4 = false;
        try {
            this.sessionContext = ReferenceCountedOpenSslServerContext.newSessionContext(this, this.ctx, this.engines, x509CertificateArray, trustManagerFactory, x509CertificateArray2, privateKey, string, keyManagerFactory, string2, l2, l3, resumptionController);
            if (SERVER_ENABLE_SESSION_TICKET) {
                this.sessionContext.setTicketKeys(new OpenSslSessionTicketKey[0]);
            }
            bl4 = true;
        }
        finally {
            if (!bl4) {
                this.release();
            }
        }
    }

    @Override
    public OpenSslServerSessionContext sessionContext() {
        return this.sessionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static OpenSslServerSessionContext newSessionContext(ReferenceCountedOpenSslContext referenceCountedOpenSslContext, long l2, Map<Long, ReferenceCountedOpenSslEngine> map, X509Certificate[] x509CertificateArray, TrustManagerFactory trustManagerFactory, X509Certificate[] x509CertificateArray2, PrivateKey privateKey, String string, KeyManagerFactory keyManagerFactory, String string2, long l3, long l4, ResumptionController resumptionController) throws SSLException {
        OpenSslKeyMaterialProvider openSslKeyMaterialProvider = null;
        try {
            Object object;
            Object object2;
            try {
                SSLContext.setVerify((long)l2, (int)0, (int)10);
                if (!OpenSsl.useKeyManagerFactory()) {
                    if (keyManagerFactory != null) {
                        throw new IllegalArgumentException("KeyManagerFactory not supported");
                    }
                    ObjectUtil.checkNotNull(x509CertificateArray2, "keyCertChain");
                    ReferenceCountedOpenSslServerContext.setKeyMaterial(l2, x509CertificateArray2, privateKey, string);
                } else {
                    if (keyManagerFactory == null) {
                        object2 = ReferenceCountedOpenSslServerContext.keyStorePassword(string);
                        object = ReferenceCountedOpenSslServerContext.buildKeyStore(x509CertificateArray2, privateKey, object2, string2);
                        keyManagerFactory = object.aliases().hasMoreElements() ? new OpenSslX509KeyManagerFactory() : new OpenSslCachingX509KeyManagerFactory(KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm()));
                        keyManagerFactory.init((KeyStore)object, (char[])object2);
                    }
                    openSslKeyMaterialProvider = ReferenceCountedOpenSslServerContext.providerFor(keyManagerFactory, string);
                    SSLContext.setCertificateCallback((long)l2, (CertificateCallback)new OpenSslServerCertificateCallback(map, new OpenSslKeyMaterialManager(openSslKeyMaterialProvider, referenceCountedOpenSslContext.hasTmpDhKeys)));
                }
            }
            catch (Exception exception) {
                throw new SSLException("failed to set certificate and key", exception);
            }
            try {
                if (x509CertificateArray != null) {
                    trustManagerFactory = ReferenceCountedOpenSslServerContext.buildTrustManagerFactory(x509CertificateArray, trustManagerFactory, string2);
                } else if (trustManagerFactory == null) {
                    trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    trustManagerFactory.init((KeyStore)null);
                }
                object2 = ReferenceCountedOpenSslServerContext.chooseTrustManager(trustManagerFactory.getTrustManagers(), resumptionController);
                ReferenceCountedOpenSslServerContext.setVerifyCallback(l2, map, (X509TrustManager)object2);
                object = object2.getAcceptedIssuers();
                if (object != null && ((X509Certificate[])object).length > 0) {
                    long l5 = 0L;
                    try {
                        l5 = ReferenceCountedOpenSslServerContext.toBIO(ByteBufAllocator.DEFAULT, object);
                        if (!SSLContext.setCACertificateBio((long)l2, (long)l5)) {
                            String string3 = "unable to setup accepted issuers for trustmanager " + object2;
                            int n2 = SSL.getLastErrorNumber();
                            if (n2 != 0) {
                                string3 = string3 + ". " + SSL.getErrorString((long)n2);
                            }
                            throw new SSLException(string3);
                        }
                    }
                    finally {
                        ReferenceCountedOpenSslServerContext.freeBio(l5);
                    }
                }
                SSLContext.setSniHostnameMatcher((long)l2, (SniHostNameMatcher)new OpenSslSniHostnameMatcher(map));
            }
            catch (SSLException sSLException) {
                throw sSLException;
            }
            catch (Exception exception) {
                throw new SSLException("unable to setup trustmanager", exception);
            }
            object2 = new OpenSslServerSessionContext(referenceCountedOpenSslContext, openSslKeyMaterialProvider);
            object2.setSessionIdContext(ID);
            object2.setSessionCacheEnabled(SERVER_ENABLE_SESSION_CACHE);
            if (l3 > 0L) {
                object2.setSessionCacheSize((int)Math.min(l3, Integer.MAX_VALUE));
            }
            if (l4 > 0L) {
                object2.setSessionTimeout((int)Math.min(l4, Integer.MAX_VALUE));
            }
            openSslKeyMaterialProvider = null;
            object = object2;
            return object;
        }
        finally {
            if (openSslKeyMaterialProvider != null) {
                openSslKeyMaterialProvider.destroy();
            }
        }
    }

    private static void setVerifyCallback(long l2, Map<Long, ReferenceCountedOpenSslEngine> map, X509TrustManager x509TrustManager) {
        if (ReferenceCountedOpenSslServerContext.useExtendedTrustManager(x509TrustManager)) {
            SSLContext.setCertVerifyCallback((long)l2, (CertificateVerifier)new ExtendedTrustManagerVerifyCallback(map, (X509ExtendedTrustManager)x509TrustManager));
        } else {
            SSLContext.setCertVerifyCallback((long)l2, (CertificateVerifier)new TrustManagerVerifyCallback(map, x509TrustManager));
        }
    }

    private static final class OpenSslSniHostnameMatcher
    implements SniHostNameMatcher {
        private final Map<Long, ReferenceCountedOpenSslEngine> engines;

        OpenSslSniHostnameMatcher(Map<Long, ReferenceCountedOpenSslEngine> map) {
            this.engines = map;
        }
    }

    private static final class ExtendedTrustManagerVerifyCallback
    extends ReferenceCountedOpenSslContext.AbstractCertificateVerifier {
        private final X509ExtendedTrustManager manager;

        ExtendedTrustManagerVerifyCallback(Map<Long, ReferenceCountedOpenSslEngine> map, X509ExtendedTrustManager x509ExtendedTrustManager) {
            super(map);
            this.manager = x509ExtendedTrustManager;
        }
    }

    private static final class TrustManagerVerifyCallback
    extends ReferenceCountedOpenSslContext.AbstractCertificateVerifier {
        private final X509TrustManager manager;

        TrustManagerVerifyCallback(Map<Long, ReferenceCountedOpenSslEngine> map, X509TrustManager x509TrustManager) {
            super(map);
            this.manager = x509TrustManager;
        }
    }

    private static final class OpenSslServerCertificateCallback
    implements CertificateCallback {
        private final Map<Long, ReferenceCountedOpenSslEngine> engines;
        private final OpenSslKeyMaterialManager keyManagerHolder;

        OpenSslServerCertificateCallback(Map<Long, ReferenceCountedOpenSslEngine> map, OpenSslKeyMaterialManager openSslKeyMaterialManager) {
            this.engines = map;
            this.keyManagerHolder = openSslKeyMaterialManager;
        }
    }
}

