/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl;

import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.OpenSslInternalSession;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.OpenSslSessionCache;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import com.gradle.scan.plugin.internal.dep.io.netty.internal.tcnative.SSL;
import com.gradle.scan.plugin.internal.dep.io.netty.util.AsciiString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

final class OpenSslClientSessionCache
extends OpenSslSessionCache {
    private final Map<HostPort, Set<OpenSslSessionCache.NativeSslSession>> sessions = new HashMap<HostPort, Set<OpenSslSessionCache.NativeSslSession>>();

    OpenSslClientSessionCache(Map<Long, ReferenceCountedOpenSslEngine> map) {
        super(map);
    }

    @Override
    protected void sessionRemoved(OpenSslSessionCache.NativeSslSession nativeSslSession) {
        assert (Thread.holdsLock(this));
        HostPort hostPort = OpenSslClientSessionCache.keyFor(nativeSslSession.getPeerHost(), nativeSslSession.getPeerPort());
        if (hostPort == null) {
            return;
        }
        Set<OpenSslSessionCache.NativeSslSession> set = this.sessions.get(hostPort);
        if (set != null) {
            set.remove(nativeSslSession);
            if (set.isEmpty()) {
                this.sessions.remove(hostPort);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean setSession(long l2, OpenSslInternalSession openSslInternalSession, String string, int n2) {
        boolean bl2;
        HostPort hostPort = OpenSslClientSessionCache.keyFor(string, n2);
        if (hostPort == null) {
            return false;
        }
        OpenSslSessionCache.NativeSslSession nativeSslSession = null;
        boolean bl3 = false;
        OpenSslClientSessionCache openSslClientSessionCache = this;
        synchronized (openSslClientSessionCache) {
            Set<OpenSslSessionCache.NativeSslSession> set = this.sessions.get(hostPort);
            if (set == null) {
                return false;
            }
            if (set.isEmpty()) {
                this.sessions.remove(hostPort);
                return false;
            }
            ArrayList<OpenSslSessionCache.NativeSslSession> arrayList = null;
            for (OpenSslSessionCache.NativeSslSession nativeSslSession2 : set) {
                if (nativeSslSession2.isValid()) {
                    nativeSslSession = nativeSslSession2;
                    break;
                }
                if (arrayList == null) {
                    arrayList = new ArrayList<OpenSslSessionCache.NativeSslSession>(2);
                }
                arrayList.add(nativeSslSession2);
            }
            if (arrayList != null) {
                for (OpenSslSessionCache.NativeSslSession nativeSslSession2 : arrayList) {
                    this.removeSessionWithId(nativeSslSession2.sessionId());
                }
            }
            if (nativeSslSession == null) {
                return false;
            }
            bl2 = SSL.setSession((long)l2, (long)nativeSslSession.session());
            if (bl2) {
                bl3 = nativeSslSession.shouldBeSingleUse();
            }
        }
        if (bl2) {
            if (bl3) {
                nativeSslSession.invalidate();
                openSslInternalSession.invalidate();
            }
            nativeSslSession.setLastAccessedTime(System.currentTimeMillis());
            openSslInternalSession.setSessionDetails(nativeSslSession.getCreationTime(), nativeSslSession.getLastAccessedTime(), nativeSslSession.sessionId(), nativeSslSession.keyValueStorage);
        }
        return bl2;
    }

    private static HostPort keyFor(String string, int n2) {
        if (string == null && n2 < 1) {
            return null;
        }
        return new HostPort(string, n2);
    }

    @Override
    synchronized void clear() {
        super.clear();
        this.sessions.clear();
    }

    private static final class HostPort {
        private final int hash;
        private final String host;
        private final int port;

        HostPort(String string, int n2) {
            this.host = string;
            this.port = n2;
            this.hash = 31 * AsciiString.hashCode(string) + n2;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            if (!(object instanceof HostPort)) {
                return false;
            }
            HostPort hostPort = (HostPort)object;
            return this.port == hostPort.port && this.host.equalsIgnoreCase(hostPort.host);
        }

        public String toString() {
            return "HostPort{host='" + this.host + '\'' + ", port=" + this.port + '}';
        }
    }
}

