/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.websocketx;

import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBufUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.Unpooled;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.ChannelFutureListener;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.ChannelHandlerContext;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.ByteToMessageDecoder;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.TooLongFrameException;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.websocketx.CorruptedWebSocketFrameException;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.websocketx.Utf8Validator;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.websocketx.WebSocketDecoderConfig;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.websocketx.WebSocketUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.ReferenceCounted;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.GenericFutureListener;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteOrder;
import java.util.List;

public class WebSocket08FrameDecoder
extends ByteToMessageDecoder
implements WebSocketFrameDecoder {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(WebSocket08FrameDecoder.class);
    private final WebSocketDecoderConfig config;
    private int fragmentedFramesCount;
    private boolean frameFinalFlag;
    private boolean frameMasked;
    private int frameRsv;
    private int frameOpcode;
    private long framePayloadLength;
    private int mask;
    private int framePayloadLen1;
    private boolean receivedClosingHandshake;
    private State state = State.READING_FIRST;

    public WebSocket08FrameDecoder(boolean bl2, boolean bl3, int n2, boolean bl4) {
        this(WebSocketDecoderConfig.newBuilder().expectMaskedFrames(bl2).allowExtensions(bl3).maxFramePayloadLength(n2).allowMaskMismatch(bl4).build());
    }

    public WebSocket08FrameDecoder(WebSocketDecoderConfig webSocketDecoderConfig) {
        this.config = ObjectUtil.checkNotNull(webSocketDecoderConfig, "decoderConfig");
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) throws Exception {
        if (this.receivedClosingHandshake) {
            byteBuf.skipBytes(this.actualReadableBytes());
            return;
        }
        switch (this.state) {
            case READING_FIRST: {
                if (!byteBuf.isReadable()) {
                    return;
                }
                this.framePayloadLength = 0L;
                byte by2 = byteBuf.readByte();
                this.frameFinalFlag = (by2 & 0x80) != 0;
                this.frameRsv = (by2 & 0x70) >> 4;
                this.frameOpcode = by2 & 0xF;
                if (logger.isTraceEnabled()) {
                    logger.trace("Decoding WebSocket Frame opCode={}", this.frameOpcode);
                }
                this.state = State.READING_SECOND;
            }
            case READING_SECOND: {
                if (!byteBuf.isReadable()) {
                    return;
                }
                byte by2 = byteBuf.readByte();
                this.frameMasked = (by2 & 0x80) != 0;
                this.framePayloadLen1 = by2 & 0x7F;
                if (this.frameRsv != 0 && !this.config.allowExtensions()) {
                    this.protocolViolation(channelHandlerContext, byteBuf, "RSV != 0 and no extension negotiated, RSV:" + this.frameRsv);
                    return;
                }
                if (!this.config.allowMaskMismatch() && this.config.expectMaskedFrames() != this.frameMasked) {
                    this.protocolViolation(channelHandlerContext, byteBuf, "received a frame that is not masked as expected");
                    return;
                }
                if (this.frameOpcode > 7) {
                    if (!this.frameFinalFlag) {
                        this.protocolViolation(channelHandlerContext, byteBuf, "fragmented control frame");
                        return;
                    }
                    if (this.framePayloadLen1 > 125) {
                        this.protocolViolation(channelHandlerContext, byteBuf, "control frame with payload length > 125 octets");
                        return;
                    }
                    if (this.frameOpcode != 8 && this.frameOpcode != 9 && this.frameOpcode != 10) {
                        this.protocolViolation(channelHandlerContext, byteBuf, "control frame using reserved opcode " + this.frameOpcode);
                        return;
                    }
                    if (this.frameOpcode == 8 && this.framePayloadLen1 == 1) {
                        this.protocolViolation(channelHandlerContext, byteBuf, "received close control frame with payload len 1");
                        return;
                    }
                } else {
                    if (this.frameOpcode != 0 && this.frameOpcode != 1 && this.frameOpcode != 2) {
                        this.protocolViolation(channelHandlerContext, byteBuf, "data frame using reserved opcode " + this.frameOpcode);
                        return;
                    }
                    if (this.fragmentedFramesCount == 0 && this.frameOpcode == 0) {
                        this.protocolViolation(channelHandlerContext, byteBuf, "received continuation data frame outside fragmented message");
                        return;
                    }
                    if (this.fragmentedFramesCount != 0 && this.frameOpcode != 0) {
                        this.protocolViolation(channelHandlerContext, byteBuf, "received non-continuation data frame while inside fragmented message");
                        return;
                    }
                }
                this.state = State.READING_SIZE;
            }
            case READING_SIZE: {
                if (this.framePayloadLen1 == 126) {
                    if (byteBuf.readableBytes() < 2) {
                        return;
                    }
                    this.framePayloadLength = byteBuf.readUnsignedShort();
                    if (this.framePayloadLength < 126L) {
                        this.protocolViolation(channelHandlerContext, byteBuf, "invalid data frame length (not using minimal length encoding)");
                        return;
                    }
                } else if (this.framePayloadLen1 == 127) {
                    if (byteBuf.readableBytes() < 8) {
                        return;
                    }
                    this.framePayloadLength = byteBuf.readLong();
                    if (this.framePayloadLength < 0L) {
                        this.protocolViolation(channelHandlerContext, byteBuf, "invalid data frame length (negative length)");
                        return;
                    }
                    if (this.framePayloadLength < 65536L) {
                        this.protocolViolation(channelHandlerContext, byteBuf, "invalid data frame length (not using minimal length encoding)");
                        return;
                    }
                } else {
                    this.framePayloadLength = this.framePayloadLen1;
                }
                if (this.framePayloadLength > (long)this.config.maxFramePayloadLength()) {
                    this.protocolViolation(channelHandlerContext, byteBuf, WebSocketCloseStatus.MESSAGE_TOO_BIG, "Max frame length of " + this.config.maxFramePayloadLength() + " has been exceeded.");
                    return;
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("Decoding WebSocket Frame length={}", this.framePayloadLength);
                }
                this.state = State.MASKING_KEY;
            }
            case MASKING_KEY: {
                if (this.frameMasked) {
                    if (byteBuf.readableBytes() < 4) {
                        return;
                    }
                    this.mask = byteBuf.readInt();
                }
                this.state = State.PAYLOAD;
            }
            case PAYLOAD: {
                if ((long)byteBuf.readableBytes() < this.framePayloadLength) {
                    return;
                }
                ByteBuf byteBuf2 = Unpooled.EMPTY_BUFFER;
                try {
                    if (this.framePayloadLength > 0L) {
                        byteBuf2 = ByteBufUtil.readBytes(channelHandlerContext.alloc(), byteBuf, WebSocket08FrameDecoder.toFrameLength(this.framePayloadLength));
                    }
                    this.state = State.READING_FIRST;
                    if (this.frameMasked & this.framePayloadLength > 0L) {
                        this.unmask(byteBuf2);
                    }
                    if (this.frameOpcode == 9) {
                        list.add(new PingWebSocketFrame(this.frameFinalFlag, this.frameRsv, byteBuf2));
                        byteBuf2 = null;
                        return;
                    }
                    if (this.frameOpcode == 10) {
                        list.add(new PongWebSocketFrame(this.frameFinalFlag, this.frameRsv, byteBuf2));
                        byteBuf2 = null;
                        return;
                    }
                    if (this.frameOpcode == 8) {
                        this.receivedClosingHandshake = true;
                        this.checkCloseFrameBody(channelHandlerContext, byteBuf2);
                        list.add(new CloseWebSocketFrame(this.frameFinalFlag, this.frameRsv, byteBuf2));
                        byteBuf2 = null;
                        return;
                    }
                    this.fragmentedFramesCount = this.frameFinalFlag ? 0 : ++this.fragmentedFramesCount;
                    if (this.frameOpcode == 1) {
                        list.add(new TextWebSocketFrame(this.frameFinalFlag, this.frameRsv, byteBuf2));
                        byteBuf2 = null;
                        return;
                    }
                    if (this.frameOpcode == 2) {
                        list.add(new BinaryWebSocketFrame(this.frameFinalFlag, this.frameRsv, byteBuf2));
                        byteBuf2 = null;
                        return;
                    }
                    if (this.frameOpcode == 0) {
                        list.add(new ContinuationWebSocketFrame(this.frameFinalFlag, this.frameRsv, byteBuf2));
                        byteBuf2 = null;
                        return;
                    }
                    throw new UnsupportedOperationException("Cannot decode web socket frame with opcode: " + this.frameOpcode);
                }
                finally {
                    if (byteBuf2 != null) {
                        byteBuf2.release();
                    }
                }
            }
            case CORRUPT: {
                if (byteBuf.isReadable()) {
                    byteBuf.readByte();
                }
                return;
            }
        }
        throw new Error("Shouldn't reach here.");
    }

    private void unmask(ByteBuf byteBuf) {
        int n2;
        int n3 = byteBuf.writerIndex();
        ByteOrder byteOrder = byteBuf.order();
        int n4 = this.mask;
        if (n4 == 0) {
            return;
        }
        long l2 = (long)n4 & 0xFFFFFFFFL;
        l2 |= l2 << 32;
        int n5 = n3 - 7;
        for (n2 = byteBuf.readerIndex(); n2 < n5; n2 += 8) {
            byteBuf.setLong(n2, byteBuf.getLong(n2) ^ l2);
        }
        if (n2 < n3 - 3) {
            byteBuf.setInt(n2, byteBuf.getInt(n2) ^ (int)l2);
            n2 += 4;
        }
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            n4 = Integer.reverseBytes(n4);
        }
        n5 = 0;
        while (n2 < n3) {
            byteBuf.setByte(n2, byteBuf.getByte(n2) ^ WebSocketUtil.byteAtIndex(n4, n5++ & 3));
            ++n2;
        }
    }

    private void protocolViolation(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, String string) {
        this.protocolViolation(channelHandlerContext, byteBuf, WebSocketCloseStatus.PROTOCOL_ERROR, string);
    }

    private void protocolViolation(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, WebSocketCloseStatus webSocketCloseStatus, String string) {
        this.protocolViolation(channelHandlerContext, byteBuf, new CorruptedWebSocketFrameException(webSocketCloseStatus, string));
    }

    private void protocolViolation(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, CorruptedWebSocketFrameException corruptedWebSocketFrameException) {
        this.state = State.CORRUPT;
        int n2 = byteBuf.readableBytes();
        if (n2 > 0) {
            byteBuf.skipBytes(n2);
        }
        if (channelHandlerContext.channel().isActive() && this.config.closeOnProtocolViolation()) {
            ReferenceCounted referenceCounted;
            if (this.receivedClosingHandshake) {
                referenceCounted = Unpooled.EMPTY_BUFFER;
            } else {
                WebSocketCloseStatus webSocketCloseStatus = corruptedWebSocketFrameException.closeStatus();
                String string = corruptedWebSocketFrameException.getMessage();
                if (string == null) {
                    string = webSocketCloseStatus.reasonText();
                }
                referenceCounted = new CloseWebSocketFrame(webSocketCloseStatus, string);
            }
            channelHandlerContext.writeAndFlush(referenceCounted).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        throw corruptedWebSocketFrameException;
    }

    private static int toFrameLength(long l2) {
        if (l2 > Integer.MAX_VALUE) {
            throw new TooLongFrameException("frame length exceeds 2147483647: " + l2);
        }
        return (int)l2;
    }

    protected void checkCloseFrameBody(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) {
        short s2;
        if (byteBuf == null || !byteBuf.isReadable()) {
            return;
        }
        if (byteBuf.readableBytes() < 2) {
            this.protocolViolation(channelHandlerContext, byteBuf, WebSocketCloseStatus.INVALID_PAYLOAD_DATA, "Invalid close frame body");
        }
        if (!WebSocketCloseStatus.isValidStatusCode(s2 = byteBuf.getShort(byteBuf.readerIndex()))) {
            this.protocolViolation(channelHandlerContext, byteBuf, "Invalid close frame getStatus code: " + s2);
        }
        if (byteBuf.readableBytes() > 2) {
            try {
                new Utf8Validator().check(byteBuf, byteBuf.readerIndex() + 2, byteBuf.readableBytes() - 2);
            }
            catch (CorruptedWebSocketFrameException corruptedWebSocketFrameException) {
                this.protocolViolation(channelHandlerContext, byteBuf, corruptedWebSocketFrameException);
            }
        }
    }

    static enum State {
        READING_FIRST,
        READING_SECOND,
        READING_SIZE,
        MASKING_KEY,
        PAYLOAD,
        CORRUPT;

    }
}

