package org.gradle.kotlin.dsl

import com.gradle.develocity.agent.gradle.DevelocityConfiguration
import com.gradle.develocity.agent.gradle.internal.DevelocityConfigurationInternal
import com.gradle.develocity.agent.gradle.internal.test.DevelocityTestConfigurationInternal
import com.gradle.develocity.agent.gradle.test.DevelocityTestConfiguration
import org.gradle.api.initialization.Settings
import org.gradle.api.plugins.ExtensionAware
import org.gradle.api.tasks.testing.Test

@Suppress("unused")
val Settings.develocity: DevelocityConfiguration
    get() = the()

@Suppress("unused")
fun Settings.develocity(configure: DevelocityConfiguration.() -> Unit) =
    (this as ExtensionAware).extensions.configure(DevelocityConfigurationInternal.EXTENSION_NAME, configure)

@Suppress("unused")
val Test.develocity: DevelocityTestConfiguration
    get() = the()

@Suppress("unused")
fun Test.develocity(configure: DevelocityTestConfiguration.() -> Unit) =
    (this as ExtensionAware).extensions.configure(DevelocityTestConfigurationInternal.EXTENSION_NAME, configure)
