/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.testsreader;

import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.org.objectweb.asm.ClassReader;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.org.objectweb.asm.ClassVisitor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestsReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestsReader.class);
    private final Set<File> testClassesDirs;
    private final Iterable<File> classpath;

    public TestsReader(Set<File> set, Iterable<File> iterable) {
        this.testClassesDirs = set;
        this.classpath = iterable;
    }

    public <R> Optional<R> readTestClassDirClass(String string, Supplier<? extends Visitor<R>> supplier) {
        return this.testClassesDirs.stream().map(file -> new File((File)file, this.classFileName(string))).filter(File::exists).findFirst().map(file -> this.visitClassFile((File)file, (Visitor)supplier.get()));
    }

    public <R> Optional<R> readClass(String string, Supplier<? extends Visitor<R>> supplier) {
        Optional<R> optional = this.readTestClassDirClass(string, supplier);
        if (optional.isPresent()) {
            return optional;
        }
        return this.readClasspathClass(string, supplier);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private <R> R visitClassFile(File file, Visitor<R> visitor) {
        try (InputStream inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            R r2 = this.visit(inputStream, visitor);
            return r2;
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (!illegalArgumentException.getMessage().startsWith("Unsupported class file major version")) throw illegalArgumentException;
            LOGGER.warn("Could not parse class, ignoring for retry", (Throwable)illegalArgumentException);
            return null;
        }
    }

    private <R> R visit(InputStream inputStream, Visitor<R> visitor) throws IOException {
        ClassReader classReader = new ClassReader(inputStream);
        classReader.accept(visitor, 0);
        return visitor.getResult();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private <R> Optional<R> readClasspathClass(String string, Supplier<? extends Visitor<R>> supplier) {
        String string2 = this.classFileName(string);
        for (File file : this.classpath) {
            Object object;
            if (!file.exists()) continue;
            if (file.isDirectory()) {
                object = new File(file, string2);
                if (!((File)object).exists()) continue;
                return Optional.of(this.visitClassFile((File)object, supplier.get()));
            }
            if (!file.getName().endsWith(".jar")) continue;
            try {
                object = new JarFile(file);
                try {
                    Optional<R> optional;
                    block15: {
                        Optional<JarEntry> optional2 = ((JarFile)object).stream().filter(jarEntry -> jarEntry.getName().equals(string2)).findAny();
                        if (!optional2.isPresent()) continue;
                        InputStream inputStream = ((JarFile)object).getInputStream(optional2.get());
                        try {
                            optional = Optional.of(this.visit(inputStream, supplier.get()));
                            if (inputStream == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        inputStream.close();
                    }
                    return optional;
                }
                finally {
                    ((ZipFile)object).close();
                }
            }
            catch (IOException iOException) {}
        }
        return Optional.empty();
    }

    @NotNull
    private String classFileName(String string) {
        return string.replace('.', '/') + ".class";
    }

    public static abstract class Visitor<T>
    extends ClassVisitor {
        public Visitor() {
            super(458752);
        }

        public abstract T getResult();
    }
}

