/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.channel;

import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBufAllocator;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.ChannelConfig;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.MaxMessagesRecvByteBufAllocator;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.RecvByteBufAllocator$ExtendedHandle;
import com.gradle.scan.plugin.internal.dep.io.netty.util.UncheckedBooleanSupplier;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.ObjectUtil;

public abstract class DefaultMaxMessagesRecvByteBufAllocator
implements MaxMessagesRecvByteBufAllocator {
    private final boolean ignoreBytesRead;
    private volatile int maxMessagesPerRead;
    private volatile boolean respectMaybeMoreData = true;

    public DefaultMaxMessagesRecvByteBufAllocator() {
        this(1);
    }

    public DefaultMaxMessagesRecvByteBufAllocator(int n2) {
        this(n2, false);
    }

    DefaultMaxMessagesRecvByteBufAllocator(int n2, boolean bl2) {
        this.ignoreBytesRead = bl2;
        this.maxMessagesPerRead(n2);
    }

    @Override
    public int maxMessagesPerRead() {
        return this.maxMessagesPerRead;
    }

    @Override
    public MaxMessagesRecvByteBufAllocator maxMessagesPerRead(int n2) {
        ObjectUtil.checkPositive(n2, "maxMessagesPerRead");
        this.maxMessagesPerRead = n2;
        return this;
    }

    public abstract class MaxMessageHandle
    implements RecvByteBufAllocator$ExtendedHandle {
        private ChannelConfig config;
        private int maxMessagePerRead;
        private int totalMessages;
        private int totalBytesRead;
        private int attemptedBytesRead;
        private int lastBytesRead;
        private final boolean respectMaybeMoreData;
        private final UncheckedBooleanSupplier defaultMaybeMoreSupplier;

        public MaxMessageHandle() {
            this.respectMaybeMoreData = DefaultMaxMessagesRecvByteBufAllocator.this.respectMaybeMoreData;
            this.defaultMaybeMoreSupplier = new UncheckedBooleanSupplier(){

                @Override
                public boolean get() {
                    return MaxMessageHandle.this.attemptedBytesRead == MaxMessageHandle.this.lastBytesRead;
                }
            };
        }

        @Override
        public void reset(ChannelConfig channelConfig) {
            this.config = channelConfig;
            this.maxMessagePerRead = DefaultMaxMessagesRecvByteBufAllocator.this.maxMessagesPerRead();
            this.totalBytesRead = 0;
            this.totalMessages = 0;
        }

        @Override
        public ByteBuf allocate(ByteBufAllocator byteBufAllocator) {
            return byteBufAllocator.ioBuffer(this.guess());
        }

        @Override
        public final void incMessagesRead(int n2) {
            this.totalMessages += n2;
        }

        @Override
        public void lastBytesRead(int n2) {
            this.lastBytesRead = n2;
            if (n2 > 0) {
                this.totalBytesRead += n2;
            }
        }

        @Override
        public final int lastBytesRead() {
            return this.lastBytesRead;
        }

        @Override
        public boolean continueReading() {
            return this.continueReading(this.defaultMaybeMoreSupplier);
        }

        public boolean continueReading(UncheckedBooleanSupplier uncheckedBooleanSupplier) {
            return !(!this.config.isAutoRead() || this.respectMaybeMoreData && !uncheckedBooleanSupplier.get() || this.totalMessages >= this.maxMessagePerRead || !DefaultMaxMessagesRecvByteBufAllocator.this.ignoreBytesRead && this.totalBytesRead <= 0);
        }

        @Override
        public void readComplete() {
        }

        @Override
        public int attemptedBytesRead() {
            return this.attemptedBytesRead;
        }

        @Override
        public void attemptedBytesRead(int n2) {
            this.attemptedBytesRead = n2;
        }

        protected final int totalBytesRead() {
            return this.totalBytesRead < 0 ? Integer.MAX_VALUE : this.totalBytesRead;
        }
    }
}

