/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.jsontype.impl;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.DatabindContext;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.DeserializationFeature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.jsontype.NamedType;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.type.TypeFactory;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

public class ClassNameIdResolver
extends TypeIdResolverBase
implements Serializable {
    protected final PolymorphicTypeValidator _subTypeValidator;
    protected final Set<String> _allowedSubtypes;

    public ClassNameIdResolver(JavaType javaType, TypeFactory typeFactory, Collection<NamedType> collection, PolymorphicTypeValidator polymorphicTypeValidator) {
        super(javaType, typeFactory);
        this._subTypeValidator = polymorphicTypeValidator;
        HashSet<String> hashSet = null;
        if (collection != null) {
            for (NamedType namedType : collection) {
                if (hashSet == null) {
                    hashSet = new HashSet<String>();
                }
                hashSet.add(namedType.getType().getName());
            }
        }
        this._allowedSubtypes = hashSet == null ? Collections.emptySet() : hashSet;
    }

    public static ClassNameIdResolver construct(JavaType javaType, MapperConfig<?> mapperConfig, Collection<NamedType> collection, PolymorphicTypeValidator polymorphicTypeValidator) {
        return new ClassNameIdResolver(javaType, mapperConfig.getTypeFactory(), collection, polymorphicTypeValidator);
    }

    @Override
    public String idFromValue(Object object) {
        return this._idFrom(object, object.getClass(), this._typeFactory);
    }

    @Override
    public String idFromValueAndType(Object object, Class<?> clazz) {
        return this._idFrom(object, clazz, this._typeFactory);
    }

    @Override
    public JavaType typeFromId(DatabindContext databindContext, String string) throws IOException {
        return this._typeFromId(string, databindContext);
    }

    protected JavaType _typeFromId(String string, DatabindContext databindContext) throws IOException {
        DeserializationContext deserializationContext = null;
        if (databindContext instanceof DeserializationContext) {
            deserializationContext = (DeserializationContext)databindContext;
        }
        if (this._allowedSubtypes != null && deserializationContext != null && deserializationContext.isEnabled(DeserializationFeature.FAIL_ON_SUBTYPE_CLASS_NOT_REGISTERED) && !this._allowedSubtypes.contains(string)) {
            throw deserializationContext.invalidTypeIdException(this._baseType, string, "`DeserializationFeature.FAIL_ON_SUBTYPE_CLASS_NOT_REGISTERED` is enabled and the input class is not registered using `@JsonSubTypes` annotation");
        }
        JavaType javaType = databindContext.resolveAndValidateSubType(this._baseType, string, this._subTypeValidator);
        if (javaType == null && deserializationContext != null) {
            return deserializationContext.handleUnknownTypeId(this._baseType, string, this, "no such class found");
        }
        return javaType;
    }

    protected String _idFrom(Object object, Class<?> clazz, TypeFactory typeFactory) {
        Class<?> clazz2;
        Class<?> clazz3;
        String string = (clazz = this._resolveToParentAsNecessary(clazz)).getName();
        if (string.startsWith("java.util.")) {
            if (object instanceof EnumSet) {
                Class<? extends Enum<?>> clazz4 = ClassUtil.findEnumType((EnumSet)object);
                string = typeFactory.constructCollectionType(EnumSet.class, clazz4).toCanonical();
            } else if (object instanceof EnumMap) {
                Class<? extends Enum<?>> clazz5 = ClassUtil.findEnumType((EnumMap)object);
                Class<Object> clazz6 = Object.class;
                string = typeFactory.constructMapType(EnumMap.class, clazz5, clazz6).toCanonical();
            }
        } else if (string.indexOf(36) >= 0 && (clazz3 = ClassUtil.getOuterClass(clazz)) != null && ClassUtil.getOuterClass(clazz2 = this._baseType.getRawClass()) == null) {
            clazz = this._baseType.getRawClass();
            string = clazz.getName();
        }
        return string;
    }

    @Override
    public String getDescForKnownTypeIds() {
        return "class name used as type id";
    }
}

