/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.introspect;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.introspect.TypeResolutionContext;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.type.TypeBindings;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Objects;

final class MethodGenericTypeResolver {
    public static TypeResolutionContext narrowMethodTypeParameters(Method method, JavaType javaType, TypeFactory typeFactory, TypeResolutionContext typeResolutionContext) {
        TypeBindings typeBindings = MethodGenericTypeResolver.bindMethodTypeParameters(method, javaType, typeResolutionContext);
        return typeBindings == null ? typeResolutionContext : new TypeResolutionContext.Basic(typeFactory, typeBindings);
    }

    static TypeBindings bindMethodTypeParameters(Method method, JavaType javaType, TypeResolutionContext typeResolutionContext) {
        TypeVariable<Method>[] typeVariableArray = method.getTypeParameters();
        if (typeVariableArray.length == 0 || javaType.getBindings().isEmpty()) {
            return null;
        }
        Type type = method.getGenericReturnType();
        if (!(type instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        if (!Objects.equals(javaType.getRawClass(), parameterizedType.getRawType())) {
            return null;
        }
        Type[] typeArray = parameterizedType.getActualTypeArguments();
        ArrayList<String> arrayList = new ArrayList<String>(typeVariableArray.length);
        ArrayList<JavaType> arrayList2 = new ArrayList<JavaType>(typeVariableArray.length);
        for (int i2 = 0; i2 < typeArray.length; ++i2) {
            Type type2 = typeArray[i2];
            TypeVariable<?> typeVariable = MethodGenericTypeResolver.maybeGetTypeVariable(type2);
            if (typeVariable == null) continue;
            String string = typeVariable.getName();
            if (string == null) {
                return null;
            }
            JavaType javaType2 = javaType.getBindings().getBoundTypeOrNull(i2);
            if (javaType2 == null) {
                return null;
            }
            TypeVariable<?> typeVariable2 = MethodGenericTypeResolver.findByName(typeVariableArray, string);
            if (typeVariable2 == null) {
                return null;
            }
            if (!MethodGenericTypeResolver.pessimisticallyValidateBounds(typeResolutionContext, javaType2, typeVariable2.getBounds())) continue;
            int n2 = arrayList.indexOf(string);
            if (n2 != -1) {
                JavaType javaType3 = arrayList2.get(n2);
                if (javaType2.equals(javaType3)) continue;
                boolean bl2 = javaType3.isTypeOrSubTypeOf(javaType2.getRawClass());
                boolean bl3 = javaType2.isTypeOrSubTypeOf(javaType3.getRawClass());
                if (!bl2 && !bl3) {
                    return null;
                }
                if (!(bl2 ^ bl3) || !bl3) continue;
                arrayList2.set(n2, javaType2);
                continue;
            }
            arrayList.add(string);
            arrayList2.add(javaType2);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return TypeBindings.create(arrayList, arrayList2);
    }

    private static TypeVariable<?> maybeGetTypeVariable(Type type) {
        if (type instanceof TypeVariable) {
            return (TypeVariable)type;
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            if (wildcardType.getLowerBounds().length != 0) {
                return null;
            }
            Type[] typeArray = wildcardType.getUpperBounds();
            if (typeArray.length == 1) {
                return MethodGenericTypeResolver.maybeGetTypeVariable(typeArray[0]);
            }
        }
        return null;
    }

    private static ParameterizedType maybeGetParameterizedType(Type type) {
        if (type instanceof ParameterizedType) {
            return (ParameterizedType)type;
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            if (wildcardType.getLowerBounds().length != 0) {
                return null;
            }
            Type[] typeArray = wildcardType.getUpperBounds();
            if (typeArray.length == 1) {
                return MethodGenericTypeResolver.maybeGetParameterizedType(typeArray[0]);
            }
        }
        return null;
    }

    private static boolean pessimisticallyValidateBounds(TypeResolutionContext typeResolutionContext, JavaType javaType, Type[] typeArray) {
        for (Type type : typeArray) {
            if (MethodGenericTypeResolver.pessimisticallyValidateBound(typeResolutionContext, javaType, type)) continue;
            return false;
        }
        return true;
    }

    private static boolean pessimisticallyValidateBound(TypeResolutionContext typeResolutionContext, JavaType javaType, Type type) {
        if (!javaType.isTypeOrSubTypeOf(typeResolutionContext.resolveType(type).getRawClass())) {
            return false;
        }
        ParameterizedType parameterizedType = MethodGenericTypeResolver.maybeGetParameterizedType(type);
        if (parameterizedType != null && Objects.equals(javaType.getRawClass(), parameterizedType.getRawType())) {
            Type[] typeArray = parameterizedType.getActualTypeArguments();
            TypeBindings typeBindings = javaType.getBindings();
            if (typeBindings.size() != typeArray.length) {
                return false;
            }
            for (int i2 = 0; i2 < typeBindings.size(); ++i2) {
                Type type2;
                JavaType javaType2 = typeBindings.getBoundType(i2);
                if (MethodGenericTypeResolver.pessimisticallyValidateBound(typeResolutionContext, javaType2, type2 = typeArray[i2])) continue;
                return false;
            }
        }
        return true;
    }

    private static TypeVariable<?> findByName(TypeVariable<?>[] typeVariableArray, String string) {
        if (typeVariableArray == null || string == null) {
            return null;
        }
        for (TypeVariable<?> typeVariable : typeVariableArray) {
            if (!string.equals(typeVariable.getName())) continue;
            return typeVariable;
        }
        return null;
    }
}

