/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.filter;

import java.util.regex.Pattern;
import java.util.stream.Collectors;

final class GlobPattern {
    public static final Pattern STAR_CHAR_PATTERN = Pattern.compile("\\*");
    private final String string;
    private final Pattern pattern;

    private GlobPattern(String string, Pattern pattern) {
        this.string = string;
        this.pattern = pattern;
    }

    static GlobPattern from(String string) {
        String string2 = STAR_CHAR_PATTERN.splitAsStream(string).map(Pattern::quote).collect(Collectors.joining(".*?"));
        if (string.endsWith("*")) {
            string2 = string2 + ".*?";
        }
        Pattern pattern = Pattern.compile(string2);
        return new GlobPattern(string2, pattern);
    }

    boolean matches(String string) {
        return this.pattern.matcher(string).matches();
    }

    public String toString() {
        return this.string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        GlobPattern globPattern = (GlobPattern)object;
        return this.string.equals(globPattern.string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }
}

