/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.apache.commons.io.input;

import com.gradle.scan.plugin.internal.dep.org.apache.commons.io.function.IOBiConsumer;
import com.gradle.scan.plugin.internal.dep.org.apache.commons.io.input.ProxyInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BoundedInputStream
extends ProxyInputStream {
    private long count;
    private long mark;
    private final long maxCount;
    private final IOBiConsumer<Long, Long> onMaxCount;
    private boolean propagateClose = true;

    public static Builder builder() {
        return new Builder();
    }

    BoundedInputStream(Builder builder) throws IOException {
        super(builder);
        this.count = builder.getCount();
        this.maxCount = builder.getMaxCount();
        this.propagateClose = builder.isPropagateClose();
        this.onMaxCount = builder.getOnMaxCount();
    }

    BoundedInputStream(InputStream inputStream, Builder builder) {
        super(inputStream, builder);
        this.count = builder.getCount();
        this.maxCount = builder.getMaxCount();
        this.propagateClose = builder.isPropagateClose();
        this.onMaxCount = builder.getOnMaxCount();
    }

    @Deprecated
    public BoundedInputStream(InputStream inputStream, long l2) {
        this(inputStream, (Builder)BoundedInputStream.builder().setMaxCount(l2));
    }

    @Override
    protected synchronized void afterRead(int n2) throws IOException {
        if (n2 != -1) {
            this.count += (long)n2;
        }
        super.afterRead(n2);
    }

    @Override
    public int available() throws IOException {
        if (this.isMaxCount()) {
            this.onMaxLength(this.maxCount, this.getCount());
            return 0;
        }
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        if (this.propagateClose) {
            super.close();
        }
    }

    public synchronized long getCount() {
        return this.count;
    }

    private boolean isMaxCount() {
        return this.maxCount >= 0L && this.getCount() >= this.maxCount;
    }

    @Override
    public synchronized void mark(int n2) {
        this.in.mark(n2);
        this.mark = this.count;
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    protected void onMaxLength(long l2, long l3) throws IOException {
        this.onMaxCount.accept(l2, l3);
    }

    @Override
    public int read() throws IOException {
        if (this.isMaxCount()) {
            this.onMaxLength(this.maxCount, this.getCount());
            return -1;
        }
        return super.read();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (this.isMaxCount()) {
            this.onMaxLength(this.maxCount, this.getCount());
            return -1;
        }
        return super.read(byArray, n2, (int)this.toReadLen(n3));
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
        this.count = this.mark;
    }

    @Deprecated
    public void setPropagateClose(boolean bl2) {
        this.propagateClose = bl2;
    }

    @Override
    public synchronized long skip(long l2) throws IOException {
        long l3 = super.skip(this.toReadLen(l2));
        this.count += l3;
        return l3;
    }

    private long toReadLen(long l2) {
        return this.maxCount >= 0L ? Math.min(l2, this.maxCount - this.getCount()) : l2;
    }

    public String toString() {
        return this.in.toString();
    }

    public static class Builder
    extends AbstractBuilder<Builder> {
        public BoundedInputStream get() throws IOException {
            return new BoundedInputStream(this);
        }
    }

    static abstract class AbstractBuilder<T extends AbstractBuilder<T>>
    extends ProxyInputStream.AbstractBuilder<BoundedInputStream, T> {
        private long count;
        private long maxCount = -1L;
        private IOBiConsumer<Long, Long> onMaxCount = IOBiConsumer.noop();
        private boolean propagateClose = true;

        AbstractBuilder() {
        }

        long getCount() {
            return this.count;
        }

        long getMaxCount() {
            return this.maxCount;
        }

        IOBiConsumer<Long, Long> getOnMaxCount() {
            return this.onMaxCount;
        }

        boolean isPropagateClose() {
            return this.propagateClose;
        }

        public T setMaxCount(long l2) {
            this.maxCount = Math.max(-1L, l2);
            return (T)((AbstractBuilder)this.asThis());
        }
    }
}

