/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.util.internal;

import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.FastThreadLocalThread;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.SystemPropertyUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.ThreadLocalRandom;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.TypeParameterMatcher;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.UnpaddedInternalThreadLocalMap;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public final class InternalThreadLocalMap
extends UnpaddedInternalThreadLocalMap {
    private static final ThreadLocal<InternalThreadLocalMap> slowThreadLocalMap = new ThreadLocal();
    private static final AtomicInteger nextIndex = new AtomicInteger();
    public static final int VARIABLES_TO_REMOVE_INDEX = InternalThreadLocalMap.nextVariableIndex();
    private static final int STRING_BUILDER_INITIAL_SIZE;
    private static final int STRING_BUILDER_MAX_SIZE;
    private static final InternalLogger logger;
    public static final Object UNSET;
    private Object[] indexedVariables = InternalThreadLocalMap.newIndexedVariableTable();
    private int futureListenerStackDepth;
    private Map<Class<?>, Boolean> handlerSharableCache;
    private ThreadLocalRandom random;
    private Map<Class<?>, TypeParameterMatcher> typeParameterMatcherGetCache;
    private Map<Class<?>, Map<String, TypeParameterMatcher>> typeParameterMatcherFindCache;
    private StringBuilder stringBuilder;
    private Map<Charset, CharsetEncoder> charsetEncoderCache;

    public static InternalThreadLocalMap getIfSet() {
        Thread thread = Thread.currentThread();
        if (thread instanceof FastThreadLocalThread) {
            return ((FastThreadLocalThread)thread).threadLocalMap();
        }
        return slowThreadLocalMap.get();
    }

    public static InternalThreadLocalMap get() {
        Thread thread = Thread.currentThread();
        if (thread instanceof FastThreadLocalThread) {
            return InternalThreadLocalMap.fastGet((FastThreadLocalThread)thread);
        }
        return InternalThreadLocalMap.slowGet();
    }

    private static InternalThreadLocalMap fastGet(FastThreadLocalThread fastThreadLocalThread) {
        InternalThreadLocalMap internalThreadLocalMap = fastThreadLocalThread.threadLocalMap();
        if (internalThreadLocalMap == null) {
            internalThreadLocalMap = new InternalThreadLocalMap();
            fastThreadLocalThread.setThreadLocalMap(internalThreadLocalMap);
        }
        return internalThreadLocalMap;
    }

    private static InternalThreadLocalMap slowGet() {
        InternalThreadLocalMap internalThreadLocalMap = slowThreadLocalMap.get();
        if (internalThreadLocalMap == null) {
            internalThreadLocalMap = new InternalThreadLocalMap();
            slowThreadLocalMap.set(internalThreadLocalMap);
        }
        return internalThreadLocalMap;
    }

    public static void remove() {
        Thread thread = Thread.currentThread();
        if (thread instanceof FastThreadLocalThread) {
            ((FastThreadLocalThread)thread).setThreadLocalMap(null);
        } else {
            slowThreadLocalMap.remove();
        }
    }

    public static int nextVariableIndex() {
        int n2 = nextIndex.getAndIncrement();
        if (n2 >= 0x7FFFFFF7 || n2 < 0) {
            nextIndex.set(0x7FFFFFF7);
            throw new IllegalStateException("too many thread-local indexed variables");
        }
        return n2;
    }

    private InternalThreadLocalMap() {
    }

    private static Object[] newIndexedVariableTable() {
        Object[] objectArray = new Object[32];
        Arrays.fill(objectArray, UNSET);
        return objectArray;
    }

    public StringBuilder stringBuilder() {
        StringBuilder stringBuilder = this.stringBuilder;
        if (stringBuilder == null) {
            this.stringBuilder = new StringBuilder(STRING_BUILDER_INITIAL_SIZE);
            return this.stringBuilder;
        }
        if (stringBuilder.capacity() > STRING_BUILDER_MAX_SIZE) {
            stringBuilder.setLength(STRING_BUILDER_INITIAL_SIZE);
            stringBuilder.trimToSize();
        }
        stringBuilder.setLength(0);
        return stringBuilder;
    }

    public Map<Charset, CharsetEncoder> charsetEncoderCache() {
        Map<Charset, CharsetEncoder> map = this.charsetEncoderCache;
        if (map == null) {
            this.charsetEncoderCache = map = new IdentityHashMap<Charset, CharsetEncoder>();
        }
        return map;
    }

    public int futureListenerStackDepth() {
        return this.futureListenerStackDepth;
    }

    public void setFutureListenerStackDepth(int n2) {
        this.futureListenerStackDepth = n2;
    }

    public ThreadLocalRandom random() {
        ThreadLocalRandom threadLocalRandom = this.random;
        if (threadLocalRandom == null) {
            this.random = threadLocalRandom = new ThreadLocalRandom();
        }
        return threadLocalRandom;
    }

    public Map<Class<?>, TypeParameterMatcher> typeParameterMatcherGetCache() {
        Map<Class<?>, TypeParameterMatcher> map = this.typeParameterMatcherGetCache;
        if (map == null) {
            this.typeParameterMatcherGetCache = map = new IdentityHashMap();
        }
        return map;
    }

    public Map<Class<?>, Map<String, TypeParameterMatcher>> typeParameterMatcherFindCache() {
        Map<Class<?>, Map<String, TypeParameterMatcher>> map = this.typeParameterMatcherFindCache;
        if (map == null) {
            this.typeParameterMatcherFindCache = map = new IdentityHashMap();
        }
        return map;
    }

    public Map<Class<?>, Boolean> handlerSharableCache() {
        Map<Class<?>, Boolean> map = this.handlerSharableCache;
        if (map == null) {
            this.handlerSharableCache = map = new WeakHashMap(4);
        }
        return map;
    }

    public Object indexedVariable(int n2) {
        Object[] objectArray = this.indexedVariables;
        return n2 < objectArray.length ? objectArray[n2] : UNSET;
    }

    public boolean setIndexedVariable(int n2, Object object) {
        Object[] objectArray = this.indexedVariables;
        if (n2 < objectArray.length) {
            Object object2 = objectArray[n2];
            objectArray[n2] = object;
            return object2 == UNSET;
        }
        this.expandIndexedVariableTableAndSet(n2, object);
        return true;
    }

    private void expandIndexedVariableTableAndSet(int n2, Object object) {
        int n3;
        Object[] objectArray = this.indexedVariables;
        int n4 = objectArray.length;
        if (n2 < 0x40000000) {
            n3 = n2;
            n3 |= n3 >>> 1;
            n3 |= n3 >>> 2;
            n3 |= n3 >>> 4;
            n3 |= n3 >>> 8;
            n3 |= n3 >>> 16;
            ++n3;
        } else {
            n3 = 0x7FFFFFF7;
        }
        Object[] objectArray2 = Arrays.copyOf(objectArray, n3);
        Arrays.fill(objectArray2, n4, objectArray2.length, UNSET);
        objectArray2[n2] = object;
        this.indexedVariables = objectArray2;
    }

    public Object removeIndexedVariable(int n2) {
        Object[] objectArray = this.indexedVariables;
        if (n2 < objectArray.length) {
            Object object = objectArray[n2];
            objectArray[n2] = UNSET;
            return object;
        }
        return UNSET;
    }

    static {
        UNSET = new Object();
        STRING_BUILDER_INITIAL_SIZE = SystemPropertyUtil.getInt("com.gradle.scan.plugin.internal.dep.io.netty.threadLocalMap.stringBuilder.initialSize", 1024);
        STRING_BUILDER_MAX_SIZE = SystemPropertyUtil.getInt("com.gradle.scan.plugin.internal.dep.io.netty.threadLocalMap.stringBuilder.maxSize", 4096);
        logger = InternalLoggerFactory.getInstance(InternalThreadLocalMap.class);
        logger.debug("-Dio.netty.threadLocalMap.stringBuilder.initialSize: {}", (Object)STRING_BUILDER_INITIAL_SIZE);
        logger.debug("-Dio.netty.threadLocalMap.stringBuilder.maxSize: {}", (Object)STRING_BUILDER_MAX_SIZE);
    }
}

