/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.google.common.math;

import com.gradle.scan.plugin.internal.dep.com.google.common.math.MathPreconditions;
import java.math.RoundingMode;

public final class IntMath {
    static final byte[] maxLog10ForLeadingZeros = new byte[]{9, 9, 9, 8, 8, 8, 7, 7, 7, 6, 6, 6, 6, 5, 5, 5, 4, 4, 4, 3, 3, 3, 3, 2, 2, 2, 1, 1, 1, 0, 0, 0, 0};
    static final int[] powersOf10 = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    static final int[] halfPowersOf10 = new int[]{3, 31, 316, 3162, 31622, 316227, 3162277, 31622776, 316227766, Integer.MAX_VALUE};
    private static final int[] factorials = new int[]{1, 1, 2, 6, 24, 120, 720, 5040, 40320, 362880, 3628800, 39916800, 479001600};
    static int[] biggestBinomials = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE, 65536, 2345, 477, 193, 110, 75, 58, 49, 43, 39, 37, 35, 34, 34, 33};

    public static boolean isPowerOfTwo(int n2) {
        return n2 > 0 & (n2 & n2 - 1) == 0;
    }

    static int lessThanBranchFree(int n2, int n3) {
        return ~(~(n2 - n3)) >>> 31;
    }

    public static int log2(int n2, RoundingMode roundingMode) {
        MathPreconditions.checkPositive("x", n2);
        switch (roundingMode) {
            case UNNECESSARY: {
                MathPreconditions.checkRoundingUnnecessary(IntMath.isPowerOfTwo(n2));
            }
            case DOWN: 
            case FLOOR: {
                return 31 - Integer.numberOfLeadingZeros(n2);
            }
            case UP: 
            case CEILING: {
                return 32 - Integer.numberOfLeadingZeros(n2 - 1);
            }
            case HALF_DOWN: 
            case HALF_UP: 
            case HALF_EVEN: {
                int n3 = Integer.numberOfLeadingZeros(n2);
                int n4 = -1257966797 >>> n3;
                int n5 = 31 - n3;
                return n5 + IntMath.lessThanBranchFree(n4, n2);
            }
        }
        throw new AssertionError();
    }
}

