/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.google.common.collect;

import com.gradle.scan.plugin.internal.dep.com.google.common.base.Objects;
import com.gradle.scan.plugin.internal.dep.com.google.common.base.Preconditions;
import com.gradle.scan.plugin.internal.dep.com.google.common.collect.AbstractIndexedListIterator;
import com.gradle.scan.plugin.internal.dep.com.google.common.collect.UnmodifiableIterator;
import com.gradle.scan.plugin.internal.dep.com.google.common.collect.UnmodifiableListIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.CheckForNull;

public final class Iterators {
    static <T> UnmodifiableListIterator<T> emptyListIterator() {
        return ArrayItr.EMPTY;
    }

    public static boolean contains(Iterator<?> iterator, @CheckForNull Object object) {
        if (object == null) {
            while (iterator.hasNext()) {
                if (iterator.next() != null) continue;
                return true;
            }
        } else {
            while (iterator.hasNext()) {
                if (!object.equals(iterator.next())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean elementsEqual(Iterator<?> iterator, Iterator<?> iterator2) {
        while (iterator.hasNext()) {
            Object obj;
            if (!iterator2.hasNext()) {
                return false;
            }
            Object obj2 = iterator.next();
            if (Objects.equal(obj2, obj = iterator2.next())) continue;
            return false;
        }
        return !iterator2.hasNext();
    }

    public static <T> T getNext(Iterator<? extends T> iterator, T t2) {
        return iterator.hasNext() ? iterator.next() : t2;
    }

    @SafeVarargs
    public static <T> UnmodifiableIterator<T> forArray(T ... TArray) {
        return Iterators.forArrayWithPosition(TArray, 0);
    }

    static <T> UnmodifiableListIterator<T> forArrayWithPosition(T[] TArray, int n2) {
        if (TArray.length == 0) {
            Preconditions.checkPositionIndex(n2, TArray.length);
            return Iterators.emptyListIterator();
        }
        return new ArrayItr<T>(TArray, n2);
    }

    public static <T> UnmodifiableIterator<T> singletonIterator(T t2) {
        return new SingletonIterator<T>(t2);
    }

    private static final class ArrayItr<T>
    extends AbstractIndexedListIterator<T> {
        static final UnmodifiableListIterator<Object> EMPTY = new ArrayItr<Object>(new Object[0], 0);
        private final T[] array;

        ArrayItr(T[] TArray, int n2) {
            super(TArray.length, n2);
            this.array = TArray;
        }

        @Override
        protected T get(int n2) {
            return this.array[n2];
        }
    }

    private static final class SingletonIterator<T>
    extends UnmodifiableIterator<T> {
        private final T value;
        private boolean done;

        SingletonIterator(T t2) {
            this.value = t2;
        }

        @Override
        public boolean hasNext() {
            return !this.done;
        }

        @Override
        public T next() {
            if (this.done) {
                throw new NoSuchElementException();
            }
            this.done = true;
            return this.value;
        }
    }
}

