package com.gradle.develocity.agent.gradle.integration;

import com.gradle.obfuscation.Keep;
import org.gradle.api.provider.Provider;

import java.util.Map;

/**
 * The DSL extension for configuring the Python Develocity build agent, when Python is called from within a Gradle build.
 * <p>
 * Usage example:
 * <pre>{@code
 * tasks.register("pipInstallWithAgent", Exec) {
 *   environment.putAll(develocity.integration.python.environment.get())
 *   commandLine("pip", "install")
 * }
 * }</pre>
 *
 * @since 4.0
 */
@Keep
public interface PythonAgentConfiguration {

    /**
     * Access the environment variables used to pass information from the Gradle plugin to the Develocity Python build agent.
     * <p>
     * These variables should be injected into tasks that run Python from the command line.
     * <p>
     * Usage example:
     * <pre>{@code
     * tasks.register("pipInstallWithAgent", Exec) {
     *   environment.putAll(develocity.integration.python.environment.get())
     *   commandLine("pip", "install")
     * }
     * }</pre>
     *
     * @since 4.0
     */
    Provider<Map<String, String>> getEnvironment();
}
