/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.oshi.driver.unix.aix;

import com.gradle.scan.plugin.internal.dep.oshi.jna.platform.unix.AixLibc;
import com.gradle.scan.plugin.internal.dep.oshi.util.FileUtil;
import com.gradle.scan.plugin.internal.dep.oshi.util.tuples.Pair;
import com.gradle.scan.plugin.internal.dep.oshi.util.tuples.Triplet;
import com.sun.jna.Memory;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.platform.unix.LibCAPI;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PsInfo {
    private static final Logger LOG = LoggerFactory.getLogger(PsInfo.class);
    private static final AixLibc LIBC = AixLibc.INSTANCE;

    private PsInfo() {
    }

    public static AixLibc.AixPsInfo queryPsInfo(int n2) {
        return new AixLibc.AixPsInfo(FileUtil.readAllBytesAsBuffer(String.format(Locale.ROOT, "/proc/%d/psinfo", n2)));
    }

    public static Triplet<Integer, Long, Long> queryArgsEnvAddrs(int n2, AixLibc.AixPsInfo aixPsInfo) {
        if (aixPsInfo != null) {
            int n3 = aixPsInfo.pr_argc;
            if (n3 > 0) {
                long l2 = aixPsInfo.pr_argv;
                long l3 = aixPsInfo.pr_envp;
                return new Triplet<Integer, Long, Long>(n3, l2, l3);
            }
            LOG.trace("Failed argc sanity check: argc={}", (Object)n3);
            return null;
        }
        LOG.trace("Failed to read psinfo file for pid: {} ", (Object)n2);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pair<List<String>, Map<String, String>> queryArgsEnv(int n2, AixLibc.AixPsInfo aixPsInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        Triplet<Integer, Long, Long> triplet = PsInfo.queryArgsEnvAddrs(n2, aixPsInfo);
        if (triplet != null) {
            String string = "/proc/" + n2 + "/as";
            int n3 = LIBC.open(string, 0);
            if (n3 < 0) {
                LOG.trace("No permission to read file: {} ", (Object)string);
                return new Pair<List<String>, Map<String, String>>(arrayList, linkedHashMap);
            }
            try {
                long l2;
                Object object;
                int n4 = triplet.getA();
                long l3 = triplet.getB();
                long l4 = triplet.getC();
                Path path = Paths.get("/proc/" + n2 + "/status", new String[0]);
                try {
                    object = Files.readAllBytes(path);
                    l2 = object[17] == 1 ? 8L : 4L;
                }
                catch (IOException iOException) {
                    Pair<List<String>, Map<String, String>> pair = new Pair<List<String>, Map<String, String>>(arrayList, linkedHashMap);
                    LIBC.close(n3);
                    return pair;
                }
                object = new Memory(8192L);
                try {
                    long l5;
                    long l6;
                    LibCAPI.size_t size_t2 = new LibCAPI.size_t(((Memory)object).size());
                    long l7 = PsInfo.conditionallyReadBufferFromStartOfPage(n3, (Memory)object, size_t2, 0L, l3);
                    long[] lArray = new long[n4];
                    long l8 = l6 = l7 == 0L ? 0L : PsInfo.getOffsetFromBuffer((Memory)object, l3 - l7, l2);
                    if (l6 > 0L) {
                        for (int i2 = 0; i2 < n4; ++i2) {
                            l5 = l6 + (long)i2 * l2;
                            lArray[i2] = (l7 = PsInfo.conditionallyReadBufferFromStartOfPage(n3, (Memory)object, size_t2, l7, l5)) == 0L ? 0L : PsInfo.getOffsetFromBuffer((Memory)object, l5 - l7, l2);
                        }
                    }
                    l7 = PsInfo.conditionallyReadBufferFromStartOfPage(n3, (Memory)object, size_t2, l7, l4);
                    ArrayList<Long> arrayList2 = new ArrayList<Long>();
                    l5 = l7 == 0L ? 0L : PsInfo.getOffsetFromBuffer((Memory)object, l4 - l7, l2);
                    int n5 = 500;
                    long l9 = l5;
                    while (l5 != 0L && --n5 > 0) {
                        long l10;
                        long l11 = l10 = (l7 = PsInfo.conditionallyReadBufferFromStartOfPage(n3, (Memory)object, size_t2, l7, l9)) == 0L ? 0L : PsInfo.getOffsetFromBuffer((Memory)object, l9 - l7, l2);
                        if (l10 != 0L) {
                            arrayList2.add(l10);
                        }
                        l9 += l2;
                    }
                    for (int i3 = 0; i3 < lArray.length && lArray[i3] != 0L; ++i3) {
                        String object2;
                        if ((l7 = PsInfo.conditionallyReadBufferFromStartOfPage(n3, (Memory)object, size_t2, l7, lArray[i3])) == 0L || (object2 = ((Pointer)object).getString(lArray[i3] - l7)).isEmpty()) continue;
                        arrayList.add(object2);
                    }
                    for (Long l12 : arrayList2) {
                        String string2;
                        int n6;
                        if ((l7 = PsInfo.conditionallyReadBufferFromStartOfPage(n3, (Memory)object, size_t2, l7, l12)) == 0L || (n6 = (string2 = ((Pointer)object).getString(l12 - l7)).indexOf(61)) <= 0) continue;
                        linkedHashMap.put(string2.substring(0, n6), string2.substring(n6 + 1));
                    }
                }
                finally {
                    ((Memory)object).close();
                }
            }
            finally {
                LIBC.close(n3);
            }
        }
        return new Pair<List<String>, Map<String, String>>(arrayList, linkedHashMap);
    }

    private static long conditionallyReadBufferFromStartOfPage(int n2, Memory memory, LibCAPI.size_t size_t2, long l2, long l3) {
        if (l3 < l2 || l3 - l2 > 4096L) {
            long l4 = Math.floorDiv(l3, 4096L) * 4096L;
            LibCAPI.ssize_t ssize_t2 = LIBC.pread(n2, memory, size_t2, new NativeLong(l4));
            if (ssize_t2.longValue() < 4096L) {
                LOG.debug("Failed to read page from address space: {} bytes read", (Object)ssize_t2.longValue());
                return 0L;
            }
            return l4;
        }
        return l2;
    }

    private static long getOffsetFromBuffer(Memory memory, long l2, long l3) {
        return l3 == 8L ? memory.getLong(l2) : (long)memory.getInt(l2);
    }
}

