/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.executer;

import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.executer.RoundResult;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.executer.TestDescriptorImpl;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.executer.TestNames;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.executer.framework.TestFrameworkStrategy;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.filter.ClassRetryMatcher;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.filter.RetryFilter;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.testsreader.TestsReader;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.internal.tasks.testing.TestCompleteEvent;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.TestStartEvent;
import org.gradle.api.tasks.testing.TestFailure;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.util.GradleVersion;

final class RetryTestResultProcessor
implements TestResultProcessor {
    private final TestFrameworkStrategy testFrameworkStrategy;
    private final RetryFilter filter;
    private final ClassRetryMatcher classRetryMatcher;
    private final TestsReader testsReader;
    private final TestResultProcessor delegate;
    private final int maxFailures;
    private final boolean failOnSkippedAfterRetry;
    private boolean lastRetry;
    private boolean hasRetryFilteredFailures;
    private Method failureMethod;
    private final Map<Object, TestDescriptorInternal> activeDescriptorsById = new HashMap<Object, TestDescriptorInternal>();
    private final Map<Object, Object> parentIdByDescriptorId = new HashMap<Object, Object>();
    private final Set<String> testClassesSeenInCurrentRound = new HashSet<String>();
    private TestNames currentRoundFailedTests = new TestNames();
    private TestNames previousRoundFailedTests = new TestNames();
    private Object rootTestDescriptorId;

    RetryTestResultProcessor(TestFrameworkStrategy testFrameworkStrategy, RetryFilter retryFilter, ClassRetryMatcher classRetryMatcher, TestsReader testsReader, TestResultProcessor testResultProcessor, int n2, boolean bl2) {
        this.testFrameworkStrategy = testFrameworkStrategy;
        this.filter = retryFilter;
        this.classRetryMatcher = classRetryMatcher;
        this.testsReader = testsReader;
        this.delegate = testResultProcessor;
        this.maxFailures = n2;
        this.failOnSkippedAfterRetry = bl2;
    }

    public void started(TestDescriptorInternal testDescriptorInternal, TestStartEvent testStartEvent) {
        if (this.rootTestDescriptorId == null) {
            this.rootTestDescriptorId = testDescriptorInternal.getId();
            this.activeDescriptorsById.put(testDescriptorInternal.getId(), testDescriptorInternal);
            this.delegate.started(testDescriptorInternal, testStartEvent);
        } else if (!testDescriptorInternal.getId().equals(this.rootTestDescriptorId)) {
            this.activeDescriptorsById.put(testDescriptorInternal.getId(), testDescriptorInternal);
            this.parentIdByDescriptorId.put(testDescriptorInternal.getId(), testStartEvent.getParentId());
            this.registerSeenTestClass(testDescriptorInternal);
            this.delegate.started(testDescriptorInternal, testStartEvent);
        }
    }

    public void completed(Object object, TestCompleteEvent testCompleteEvent) {
        if (object.equals(this.rootTestDescriptorId)) {
            if (this.currentRoundFailedTests.isEmpty() && !this.previousRoundFailedTests.isEmpty()) {
                this.ignoreExpectedUnretriedTests();
            }
            if (!this.lastRun()) {
                return;
            }
        } else {
            TestDescriptorInternal testDescriptorInternal = this.activeDescriptorsById.remove(object);
            if (testDescriptorInternal != null && testDescriptorInternal.getClassName() != null) {
                boolean bl2;
                String string;
                String string3 = testDescriptorInternal.getClassName();
                boolean bl3 = this.previousRoundFailedTests.remove(string3, string = testDescriptorInternal.getName());
                boolean bl4 = bl2 = bl3 && testCompleteEvent.getResultType() == TestResult.ResultType.SKIPPED && this.failOnSkippedAfterRetry;
                if (bl2) {
                    this.addRetry(testDescriptorInternal);
                }
                if (this.isLifecycleFailure(string3, string)) {
                    this.previousRoundFailedTests.remove(string3, string2 -> {
                        if (this.isLifecycleFailure(string3, (String)string2)) {
                            this.currentRoundFailedTests.add(string3, (String)string2);
                        }
                        return true;
                    });
                }
                if (this.isClassDescriptor(testDescriptorInternal)) {
                    this.previousRoundFailedTests.remove(string3, string2 -> {
                        if (this.isLifecycleFailure(string3, (String)string2)) {
                            this.emitFakePassedEvent(testDescriptorInternal, testCompleteEvent, (String)string2);
                            return true;
                        }
                        return false;
                    });
                }
            }
        }
        this.delegate.completed(object, testCompleteEvent);
    }

    private void ignoreExpectedUnretriedTests() {
        Map<String, Set> map = this.previousRoundFailedTests.stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Set)entry.getValue()).stream().filter(string -> this.testFrameworkStrategy.isExpectedUnretriedTest((String)entry.getKey(), (String)string)).collect(Collectors.toSet())));
        map.forEach((string, set) -> this.previousRoundFailedTests.remove((String)string, set::contains));
    }

    private boolean isLifecycleFailure(String string, String string2) {
        return this.testFrameworkStrategy.isLifecycleFailureTest(this.testsReader, string, string2);
    }

    private void registerSeenTestClass(TestDescriptorInternal testDescriptorInternal) {
        String string = testDescriptorInternal.getClassName();
        if (string != null) {
            this.testClassesSeenInCurrentRound.add(string);
        }
    }

    private void addRetry(TestDescriptorInternal testDescriptorInternal) {
        Optional<TestDescriptorInternal> optional = this.firstClassMatchingClassRetryFilter(testDescriptorInternal);
        if (optional.isPresent()) {
            this.currentRoundFailedTests.addClass(optional.get().getClassName());
        } else {
            this.currentRoundFailedTests.add(testDescriptorInternal.getClassName(), testDescriptorInternal.getName());
        }
    }

    private Optional<TestDescriptorInternal> firstClassMatchingClassRetryFilter(TestDescriptorInternal testDescriptorInternal) {
        Object object = this.parentIdByDescriptorId.get(testDescriptorInternal.getId());
        if (object == null) {
            return Optional.empty();
        }
        TestDescriptorInternal testDescriptorInternal2 = this.activeDescriptorsById.get(object);
        if (testDescriptorInternal2 == null) {
            return Optional.empty();
        }
        Optional<TestDescriptorInternal> optional = this.firstClassMatchingClassRetryFilter(testDescriptorInternal2);
        if (optional.isPresent()) {
            return optional;
        }
        String string = testDescriptorInternal.getClassName();
        if (string != null && this.classRetryMatcher.retryWholeClass(string)) {
            return Optional.of(testDescriptorInternal);
        }
        return Optional.empty();
    }

    private void emitFakePassedEvent(TestDescriptorInternal testDescriptorInternal, TestCompleteEvent testCompleteEvent, String string) {
        Object object = new Object();
        TestDescriptorImpl testDescriptorImpl = new TestDescriptorImpl(object, testDescriptorInternal, string);
        long l2 = testCompleteEvent.getEndTime();
        this.delegate.started((TestDescriptorInternal)testDescriptorImpl, new TestStartEvent(l2, testDescriptorInternal.getId()));
        this.delegate.completed(object, new TestCompleteEvent(l2));
    }

    private boolean isClassDescriptor(TestDescriptorInternal testDescriptorInternal) {
        return testDescriptorInternal.getClassName() != null && testDescriptorInternal.getClassName().equals(testDescriptorInternal.getName());
    }

    public void output(Object object, TestOutputEvent testOutputEvent) {
        this.delegate.output(object, testOutputEvent);
    }

    public void failure(Object object, Throwable throwable) {
        this.failure(object);
        try {
            Method method = this.lookupFailureMethod();
            method.invoke((Object)this.delegate, object, throwable);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }

    private Method lookupFailureMethod() throws ReflectiveOperationException {
        if (this.failureMethod == null) {
            this.failureMethod = this.delegate.getClass().getMethod("failure", Object.class, Throwable.class);
        }
        return this.failureMethod;
    }

    public void failure(Object object, TestFailure testFailure) {
        this.failure(object);
        this.delegate.failure(object, testFailure);
    }

    private void failure(Object object) {
        String string;
        TestDescriptorInternal testDescriptorInternal = this.activeDescriptorsById.get(object);
        if (testDescriptorInternal != null && (string = testDescriptorInternal.getClassName()) != null) {
            if (this.filter.canRetry(string)) {
                this.addRetry(testDescriptorInternal);
            } else {
                this.hasRetryFilteredFailures = true;
            }
        }
    }

    private boolean lastRun() {
        return this.currentRoundFailedTests.isEmpty() || this.hasNonRetriedTests() || this.lastRetry || this.currentRoundFailedTestsExceedsMaxFailures();
    }

    private boolean hasNonRetriedTests() {
        return !this.cleanedUpFailedTestsOfPreviousRound().isEmpty();
    }

    private boolean currentRoundFailedTestsExceedsMaxFailures() {
        return this.maxFailures > 0 && this.currentRoundFailedTests.size() >= this.maxFailures;
    }

    public RoundResult getResult() {
        return new RoundResult(this.currentRoundFailedTests, this.cleanedUpFailedTestsOfPreviousRound(), this.lastRun(), this.hasRetryFilteredFailures, this.testClassesSeenInCurrentRound);
    }

    private TestNames cleanedUpFailedTestsOfPreviousRound() {
        boolean bl2 = GradleVersion.current().getBaseVersion().equals(GradleVersion.version((String)"5.0"));
        if (bl2 && !this.testClassesSeenInCurrentRound.isEmpty() && this.previousRoundFailedTests.hasClassesWithoutTestNames()) {
            TestNames testNames = new TestNames();
            this.previousRoundFailedTests.stream().forEach(entry -> {
                String string = (String)entry.getKey();
                Set set = (Set)entry.getValue();
                if (set.isEmpty()) {
                    if (!this.testClassesSeenInCurrentRound.contains(string)) {
                        testNames.addClass(string);
                    }
                } else {
                    testNames.addAll(string, set);
                }
            });
            return testNames;
        }
        return this.previousRoundFailedTests;
    }

    public void reset(boolean bl2) {
        if (this.lastRun()) {
            throw new IllegalStateException("processor has completed");
        }
        this.lastRetry = bl2;
        this.testClassesSeenInCurrentRound.clear();
        this.previousRoundFailedTests = this.currentRoundFailedTests;
        this.currentRoundFailedTests = new TestNames();
        this.activeDescriptorsById.clear();
        this.parentIdByDescriptorId.clear();
    }
}

