/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.compression;

import com.github.luben.zstd.ZstdInputStreamNoFinalizer;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.ChannelHandlerContext;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.ByteToMessageDecoder;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.compression.DecompressionException;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.compression.Zstd;
import com.gradle.scan.plugin.internal.dep.io.netty.util.ReferenceCounted;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public final class ZstdDecoder
extends ByteToMessageDecoder {
    private final MutableByteBufInputStream inputStream;
    private ZstdInputStreamNoFinalizer zstdIs;
    private State currentState;

    public ZstdDecoder() {
        try {
            Zstd.ensureAvailability();
        }
        catch (Throwable throwable) {
            throw new ExceptionInInitializerError(throwable);
        }
        this.inputStream = new MutableByteBufInputStream();
        this.currentState = State.DECOMPRESS_DATA;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) throws Exception {
        try {
            if (this.currentState == State.CORRUPTED) {
                byteBuf.skipBytes(byteBuf.readableBytes());
                return;
            }
            int n2 = byteBuf.readableBytes();
            this.inputStream.current = byteBuf;
            ReferenceCounted referenceCounted = null;
            try {
                int n3;
                do {
                    if (referenceCounted == null) {
                        referenceCounted = channelHandlerContext.alloc().heapBuffer(n2 * 2);
                    }
                    while ((n3 = ((ByteBuf)referenceCounted).writeBytes((InputStream)this.zstdIs, ((ByteBuf)referenceCounted).writableBytes())) != -1 && ((ByteBuf)referenceCounted).isWritable()) {
                    }
                    if (!((ByteBuf)referenceCounted).isReadable()) continue;
                    list.add(referenceCounted);
                    referenceCounted = null;
                } while (n3 != -1);
            }
            finally {
                if (referenceCounted != null) {
                    referenceCounted.release();
                }
            }
        }
        catch (Exception exception) {
            this.currentState = State.CORRUPTED;
            throw new DecompressionException(exception);
        }
        finally {
            this.inputStream.current = null;
        }
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) throws Exception {
        super.handlerAdded(channelHandlerContext);
        this.zstdIs = new ZstdInputStreamNoFinalizer((InputStream)this.inputStream);
        this.zstdIs.setContinuous(true);
    }

    @Override
    protected void handlerRemoved0(ChannelHandlerContext channelHandlerContext) throws Exception {
        try {
            ZstdDecoder.closeSilently((Closeable)this.zstdIs);
        }
        finally {
            super.handlerRemoved0(channelHandlerContext);
        }
    }

    private static void closeSilently(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static final class MutableByteBufInputStream
    extends InputStream {
        ByteBuf current;

        private MutableByteBufInputStream() {
        }

        @Override
        public int read() {
            if (this.current == null || !this.current.isReadable()) {
                return -1;
            }
            return this.current.readByte() & 0xFF;
        }

        @Override
        public int read(byte[] byArray, int n2, int n3) {
            int n4 = this.available();
            if (n4 == 0) {
                return -1;
            }
            n3 = Math.min(n4, n3);
            this.current.readBytes(byArray, n2, n3);
            return n3;
        }

        @Override
        public int available() {
            return this.current == null ? 0 : this.current.readableBytes();
        }
    }

    private static enum State {
        DECOMPRESS_DATA,
        CORRUPTED;

    }
}

