/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.datatype.jdk8;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.type.LogicalType;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.datatype.jdk8.BaseScalarOptionalDeserializer;
import java.io.IOException;
import java.util.OptionalLong;

public class OptionalLongDeserializer
extends BaseScalarOptionalDeserializer<OptionalLong> {
    static final OptionalLongDeserializer INSTANCE = new OptionalLongDeserializer();

    public OptionalLongDeserializer() {
        super(OptionalLong.class, OptionalLong.empty());
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Integer;
    }

    @Override
    public OptionalLong deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (jsonParser.hasToken(JsonToken.VALUE_NUMBER_INT)) {
            return OptionalLong.of(jsonParser.getLongValue());
        }
        switch (jsonParser.currentTokenId()) {
            case 6: {
                String string = jsonParser.getText();
                CoercionAction coercionAction = this._checkFromStringCoercion(deserializationContext, string);
                if (coercionAction == CoercionAction.AsNull || coercionAction == CoercionAction.AsEmpty) {
                    return (OptionalLong)this._empty;
                }
                string = string.trim();
                return OptionalLong.of(this._parseLongPrimitive(deserializationContext, string));
            }
            case 8: {
                CoercionAction coercionAction = this._checkFloatToIntCoercion(jsonParser, deserializationContext, this._valueClass);
                if (coercionAction == CoercionAction.AsNull || coercionAction == CoercionAction.AsEmpty) {
                    return (OptionalLong)this._empty;
                }
                return OptionalLong.of(jsonParser.getValueAsLong());
            }
            case 11: {
                return (OptionalLong)this._empty;
            }
            case 3: {
                return (OptionalLong)this._deserializeFromArray(jsonParser, deserializationContext);
            }
        }
        return (OptionalLong)deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), jsonParser);
    }
}

