/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.oshi.driver.linux;

import com.gradle.scan.plugin.internal.dep.oshi.util.FileUtil;
import com.gradle.scan.plugin.internal.dep.oshi.util.ParseUtil;
import com.gradle.scan.plugin.internal.dep.oshi.util.Util;
import com.gradle.scan.plugin.internal.dep.oshi.util.platform.linux.SysPath;

public final class Sysfs {
    public static String querySystemVendor() {
        String string = FileUtil.getStringFromFile(SysPath.DMI_ID + "sys_vendor").trim();
        if (!string.isEmpty()) {
            return string;
        }
        return null;
    }

    public static String queryProductModel() {
        String string = FileUtil.getStringFromFile(SysPath.DMI_ID + "product_name").trim();
        String string2 = FileUtil.getStringFromFile(SysPath.DMI_ID + "product_version").trim();
        if (string.isEmpty()) {
            if (!string2.isEmpty()) {
                return string2;
            }
        } else {
            if (!string2.isEmpty() && !"None".equals(string2)) {
                return string + " (version: " + string2 + ")";
            }
            return string;
        }
        return null;
    }

    public static String queryProductSerial() {
        String string = FileUtil.getStringFromFile(SysPath.DMI_ID + "product_serial");
        if (!string.isEmpty() && !"None".equals(string)) {
            return string;
        }
        return Sysfs.queryBoardSerial();
    }

    public static String queryUUID() {
        String string = FileUtil.getStringFromFile(SysPath.DMI_ID + "product_uuid");
        if (!string.isEmpty() && !"None".equals(string)) {
            return string;
        }
        return null;
    }

    public static String queryBoardVendor() {
        String string = FileUtil.getStringFromFile(SysPath.DMI_ID + "board_vendor").trim();
        if (!string.isEmpty()) {
            return string;
        }
        return null;
    }

    public static String queryBoardModel() {
        String string = FileUtil.getStringFromFile(SysPath.DMI_ID + "board_name").trim();
        if (!string.isEmpty()) {
            return string;
        }
        return null;
    }

    public static String queryBoardVersion() {
        String string = FileUtil.getStringFromFile(SysPath.DMI_ID + "board_version").trim();
        if (!string.isEmpty()) {
            return string;
        }
        return null;
    }

    public static String queryBoardSerial() {
        String string = FileUtil.getStringFromFile(SysPath.DMI_ID + "board_serial").trim();
        if (!string.isEmpty()) {
            return string;
        }
        return null;
    }

    public static String queryBiosVendor() {
        String string = FileUtil.getStringFromFile(SysPath.DMI_ID + "bios_vendor").trim();
        if (string.isEmpty()) {
            return string;
        }
        return null;
    }

    public static String queryBiosDescription() {
        String string = FileUtil.getStringFromFile(SysPath.DMI_ID + "modalias").trim();
        if (!string.isEmpty()) {
            return string;
        }
        return null;
    }

    public static String queryBiosVersion(String string) {
        String string2 = FileUtil.getStringFromFile(SysPath.DMI_ID + "bios_version").trim();
        if (!string2.isEmpty()) {
            return string2 + (Util.isBlank(string) ? "" : " (revision " + string + ")");
        }
        return null;
    }

    public static String queryBiosReleaseDate() {
        String string = FileUtil.getStringFromFile(SysPath.DMI_ID + "bios_date").trim();
        if (!string.isEmpty()) {
            return ParseUtil.parseMmDdYyyyToYyyyMmDD(string);
        }
        return null;
    }
}

