/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.apache.http.message;

import com.gradle.scan.plugin.internal.dep.org.apache.http.message.ParserCursor;
import com.gradle.scan.plugin.internal.dep.org.apache.http.util.CharArrayBuffer;
import java.util.BitSet;

public class TokenParser {
    public static final TokenParser INSTANCE = new TokenParser();

    public static BitSet INIT_BITSET(int ... nArray) {
        BitSet bitSet = new BitSet();
        for (int n2 : nArray) {
            bitSet.set(n2);
        }
        return bitSet;
    }

    public static boolean isWhitespace(char c2) {
        return c2 == ' ' || c2 == '\t' || c2 == '\r' || c2 == '\n';
    }

    public String parseToken(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor, BitSet bitSet) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        while (!parserCursor.atEnd()) {
            char c2 = charArrayBuffer.charAt(parserCursor.getPos());
            if (bitSet != null && bitSet.get(c2)) break;
            if (TokenParser.isWhitespace(c2)) {
                this.skipWhiteSpace(charArrayBuffer, parserCursor);
                bl2 = true;
                continue;
            }
            if (bl2 && stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            this.copyContent(charArrayBuffer, parserCursor, bitSet, stringBuilder);
            bl2 = false;
        }
        return stringBuilder.toString();
    }

    public String parseValue(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor, BitSet bitSet) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        while (!parserCursor.atEnd()) {
            char c2 = charArrayBuffer.charAt(parserCursor.getPos());
            if (bitSet != null && bitSet.get(c2)) break;
            if (TokenParser.isWhitespace(c2)) {
                this.skipWhiteSpace(charArrayBuffer, parserCursor);
                bl2 = true;
                continue;
            }
            if (c2 == '\"') {
                if (bl2 && stringBuilder.length() > 0) {
                    stringBuilder.append(' ');
                }
                this.copyQuotedContent(charArrayBuffer, parserCursor, stringBuilder);
                bl2 = false;
                continue;
            }
            if (bl2 && stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            this.copyUnquotedContent(charArrayBuffer, parserCursor, bitSet, stringBuilder);
            bl2 = false;
        }
        return stringBuilder.toString();
    }

    public void skipWhiteSpace(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor) {
        char c2;
        int n2 = parserCursor.getPos();
        int n3 = parserCursor.getPos();
        int n4 = parserCursor.getUpperBound();
        for (int i2 = n3; i2 < n4 && TokenParser.isWhitespace(c2 = charArrayBuffer.charAt(i2)); ++i2) {
            ++n2;
        }
        parserCursor.updatePos(n2);
    }

    public void copyContent(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor, BitSet bitSet, StringBuilder stringBuilder) {
        int n2 = parserCursor.getPos();
        int n3 = parserCursor.getPos();
        int n4 = parserCursor.getUpperBound();
        for (int i2 = n3; i2 < n4; ++i2) {
            char c2 = charArrayBuffer.charAt(i2);
            if (bitSet != null && bitSet.get(c2) || TokenParser.isWhitespace(c2)) break;
            ++n2;
            stringBuilder.append(c2);
        }
        parserCursor.updatePos(n2);
    }

    public void copyUnquotedContent(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor, BitSet bitSet, StringBuilder stringBuilder) {
        int n2 = parserCursor.getPos();
        int n3 = parserCursor.getPos();
        int n4 = parserCursor.getUpperBound();
        for (int i2 = n3; i2 < n4; ++i2) {
            char c2 = charArrayBuffer.charAt(i2);
            if (bitSet != null && bitSet.get(c2) || TokenParser.isWhitespace(c2) || c2 == '\"') break;
            ++n2;
            stringBuilder.append(c2);
        }
        parserCursor.updatePos(n2);
    }

    public void copyQuotedContent(CharArrayBuffer charArrayBuffer, ParserCursor parserCursor, StringBuilder stringBuilder) {
        if (parserCursor.atEnd()) {
            return;
        }
        int n2 = parserCursor.getPos();
        int n3 = parserCursor.getPos();
        int n4 = parserCursor.getUpperBound();
        char c2 = charArrayBuffer.charAt(n2);
        if (c2 != '\"') {
            return;
        }
        ++n2;
        boolean bl2 = false;
        int n5 = ++n3;
        while (n5 < n4) {
            c2 = charArrayBuffer.charAt(n5);
            if (bl2) {
                if (c2 != '\"' && c2 != '\\') {
                    stringBuilder.append('\\');
                }
                stringBuilder.append(c2);
                bl2 = false;
            } else {
                if (c2 == '\"') {
                    ++n2;
                    break;
                }
                if (c2 == '\\') {
                    bl2 = true;
                } else if (c2 != '\r' && c2 != '\n') {
                    stringBuilder.append(c2);
                }
            }
            ++n5;
            ++n2;
        }
        parserCursor.updatePos(n2);
    }
}

