/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.apache.http.client.protocol;

import com.gradle.scan.plugin.internal.dep.org.apache.http.auth.AuthSchemeProvider;
import com.gradle.scan.plugin.internal.dep.org.apache.http.auth.AuthState;
import com.gradle.scan.plugin.internal.dep.org.apache.http.client.AuthCache;
import com.gradle.scan.plugin.internal.dep.org.apache.http.client.CookieStore;
import com.gradle.scan.plugin.internal.dep.org.apache.http.client.CredentialsProvider;
import com.gradle.scan.plugin.internal.dep.org.apache.http.client.config.RequestConfig;
import com.gradle.scan.plugin.internal.dep.org.apache.http.config.Lookup;
import com.gradle.scan.plugin.internal.dep.org.apache.http.conn.routing.HttpRoute;
import com.gradle.scan.plugin.internal.dep.org.apache.http.conn.routing.RouteInfo;
import com.gradle.scan.plugin.internal.dep.org.apache.http.cookie.CookieOrigin;
import com.gradle.scan.plugin.internal.dep.org.apache.http.cookie.CookieSpec;
import com.gradle.scan.plugin.internal.dep.org.apache.http.cookie.CookieSpecProvider;
import com.gradle.scan.plugin.internal.dep.org.apache.http.protocol.HttpContext;
import com.gradle.scan.plugin.internal.dep.org.apache.http.protocol.HttpCoreContext;
import java.net.URI;
import java.util.List;

public class HttpClientContext
extends HttpCoreContext {
    public static HttpClientContext adapt(HttpContext httpContext) {
        return httpContext instanceof HttpClientContext ? (HttpClientContext)httpContext : new HttpClientContext(httpContext);
    }

    public HttpClientContext(HttpContext httpContext) {
        super(httpContext);
    }

    public HttpClientContext() {
    }

    public RouteInfo getHttpRoute() {
        return this.getAttribute("http.route", HttpRoute.class);
    }

    public List<URI> getRedirectLocations() {
        return this.getAttribute("http.protocol.redirect-locations", List.class);
    }

    public CookieStore getCookieStore() {
        return this.getAttribute("http.cookie-store", CookieStore.class);
    }

    public CookieSpec getCookieSpec() {
        return this.getAttribute("http.cookie-spec", CookieSpec.class);
    }

    public CookieOrigin getCookieOrigin() {
        return this.getAttribute("http.cookie-origin", CookieOrigin.class);
    }

    private <T> Lookup<T> getLookup(String string, Class<T> clazz) {
        return this.getAttribute(string, Lookup.class);
    }

    public Lookup<CookieSpecProvider> getCookieSpecRegistry() {
        return this.getLookup("http.cookiespec-registry", CookieSpecProvider.class);
    }

    public Lookup<AuthSchemeProvider> getAuthSchemeRegistry() {
        return this.getLookup("http.authscheme-registry", AuthSchemeProvider.class);
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.getAttribute("http.auth.credentials-provider", CredentialsProvider.class);
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.setAttribute("http.auth.credentials-provider", credentialsProvider);
    }

    public AuthCache getAuthCache() {
        return this.getAttribute("http.auth.auth-cache", AuthCache.class);
    }

    public void setAuthCache(AuthCache authCache) {
        this.setAttribute("http.auth.auth-cache", authCache);
    }

    public AuthState getTargetAuthState() {
        return this.getAttribute("http.auth.target-scope", AuthState.class);
    }

    public AuthState getProxyAuthState() {
        return this.getAttribute("http.auth.proxy-scope", AuthState.class);
    }

    public Object getUserToken() {
        return this.getAttribute("http.user-token");
    }

    public RequestConfig getRequestConfig() {
        RequestConfig requestConfig = this.getAttribute("http.request-config", RequestConfig.class);
        return requestConfig != null ? requestConfig : RequestConfig.DEFAULT;
    }

    public void setRequestConfig(RequestConfig requestConfig) {
        this.setAttribute("http.request-config", requestConfig);
    }
}

