/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.datatype.jdk8;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.type.ReferenceType;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.type.TypeBindings;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.type.TypeFactory;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.type.TypeModifier;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;

public class Jdk8TypeModifier
extends TypeModifier
implements Serializable {
    @Override
    public JavaType modifyType(JavaType javaType, Type type, TypeBindings typeBindings, TypeFactory typeFactory) {
        JavaType javaType2;
        if (javaType.isReferenceType() || javaType.isContainerType()) {
            return javaType;
        }
        Class<?> clazz = javaType.getRawClass();
        if (clazz == Optional.class) {
            javaType2 = javaType.containedTypeOrUnknown(0);
        } else if (clazz == OptionalInt.class) {
            javaType2 = typeFactory.constructType(Integer.TYPE);
        } else if (clazz == OptionalLong.class) {
            javaType2 = typeFactory.constructType(Long.TYPE);
        } else if (clazz == OptionalDouble.class) {
            javaType2 = typeFactory.constructType(Double.TYPE);
        } else {
            return javaType;
        }
        return ReferenceType.upgradeFrom(javaType, javaType2);
    }
}

